/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.io.input;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.TDBFactory;
import org.molgenis.vibe.core.io.input.ModelReader;

public class TripleStoreDbReader
implements ModelReader {
    private Model model;
    private Dataset dataset;

    @Override
    public Model getModel() {
        return this.model;
    }

    public TripleStoreDbReader(Path dir) throws IOException {
        this(dir.toString());
    }

    public TripleStoreDbReader(String dir) throws IOException {
        try {
            this.dataset = TDBFactory.createDataset((String)Objects.requireNonNull(dir));
            this.dataset.begin(ReadWrite.READ);
            this.model = this.dataset.getDefaultModel();
        }
        catch (TDBException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() {
        this.model.close();
        this.dataset.end();
        this.dataset.close();
    }
}

