/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.query_output_digestion.prioritization.gene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.query_output_digestion.prioritization.gene.GenePrioritizer;

public class HighestSingleDisgenetScoreGenePrioritizer
implements GenePrioritizer {
    @Override
    public List<Gene> sort(GeneDiseaseCollection collection) {
        ArrayList<Gene> genes = new ArrayList<Gene>(collection.getGenes());
        HashMap<Gene, Double> highestGeneScores = new HashMap<Gene, Double>();
        for (Gene gene : genes) {
            double scoreForGene = 0.0;
            Set<GeneDiseaseCombination> combinationsForGene = collection.getByGene(gene);
            for (GeneDiseaseCombination combination : combinationsForGene) {
                if (!(combination.getDisgenetScore() > scoreForGene)) continue;
                scoreForGene = combination.getDisgenetScore();
            }
            highestGeneScores.put(gene, scoreForGene);
        }
        Collections.sort(genes, Comparator.comparingDouble(highestGeneScores::get).reversed());
        return genes;
    }
}

