/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.tdb_processing;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.query.QuerySolution;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Entity;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.GeneSymbol;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.PubmedEvidence;
import org.molgenis.vibe.core.formats.Source;
import org.molgenis.vibe.core.io.input.ModelReader;
import org.molgenis.vibe.core.tdb_processing.DisgenetRdfDataRetriever;
import org.molgenis.vibe.core.tdb_processing.QueryRunner;
import org.molgenis.vibe.core.tdb_processing.query_string_creation.QueryStringGenerator;

public class GenesForPhenotypeRetriever
extends DisgenetRdfDataRetriever {
    private Set<Phenotype> phenotypes;
    private GeneDiseaseCollection geneDiseaseCollection = new GeneDiseaseCollection();

    public GeneDiseaseCollection getGeneDiseaseCollection() {
        return this.geneDiseaseCollection;
    }

    public GenesForPhenotypeRetriever(ModelReader modelReader, Set<Phenotype> phenotypes) {
        super(modelReader);
        this.phenotypes = Objects.requireNonNull(phenotypes);
    }

    @Override
    public void run() {
        this.retrieveSources();
        this.retrieveData();
    }

    private void retrieveData() {
        HashMap genes = new HashMap();
        HashMap diseases = new HashMap();
        HashMap foundPubmedEvidence = new HashMap();
        QueryRunner query = new QueryRunner(this.getModelReader().getModel(), QueryStringGenerator.getGenesForPhenotypes(this.phenotypes));
        while (query.hasNext()) {
            double score;
            QuerySolution result = query.next();
            Disease disease = this.processEntityQueryOutput(new Disease(URI.create(result.get("disease").asResource().getURI()), result.get("diseaseName").asLiteral().getString()), diseases);
            Gene gene = this.processEntityQueryOutput(new Gene(URI.create(result.get("gene").asResource().getURI()), new GeneSymbol(URI.create(result.get("geneSymbol").asResource().getURI()))), genes);
            GeneDiseaseCombination comparisonGdc = new GeneDiseaseCombination(gene, disease, score = result.get("gdaScoreNumber").asLiteral().getDouble());
            GeneDiseaseCombination gdc = this.geneDiseaseCollection.get(comparisonGdc);
            if (gdc == null) {
                gdc = comparisonGdc;
                this.geneDiseaseCollection.add(gdc);
            }
            Source source = this.getSources().get(URI.create(result.get("gdaSource").asResource().getURI()));
            if (result.get("evidence") != null) {
                PubmedEvidence pubmedEvidence = this.processEntityQueryOutput(new PubmedEvidence(URI.create(result.get("evidence").asResource().getURI()), Integer.parseInt(result.get("evidenceYear").asLiteral().getString())), foundPubmedEvidence);
                gdc.add(source, pubmedEvidence);
                continue;
            }
            gdc.add(source);
        }
        query.close();
    }

    private <T extends Entity> T processEntityQueryOutput(T entity, Map<T, T> foundEntities) {
        return (T)foundEntities.computeIfAbsent(entity, k -> k);
    }
}

