/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.database_processing.query_string_creation;

import org.apache.jena.query.Syntax;

public class QueryStringPathRange {
    private static final String ZERO_OR_MORE = "*";
    private static final String ONE_OR_MORE = "+";
    private static final String ZERO_OR_ONE = "?";
    private String rangeString;
    private Syntax syntax;

    public String getRangeString() {
        return this.rangeString;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public QueryStringPathRange(int value) {
        this.rangeString = "{" + value + "}";
        this.syntax = Syntax.syntaxARQ;
    }

    public QueryStringPathRange(int value, boolean isStart) {
        this.throwExceptionIfNegative(value);
        if (isStart) {
            switch (value) {
                case 0: {
                    this.rangeString = ZERO_OR_MORE;
                    this.syntax = Syntax.syntaxSPARQL_11;
                    break;
                }
                case 1: {
                    this.rangeString = ONE_OR_MORE;
                    this.syntax = Syntax.syntaxSPARQL_11;
                    break;
                }
                default: {
                    this.rangeString = "{" + value + ",}";
                    this.syntax = Syntax.syntaxARQ;
                    break;
                }
            }
        } else {
            switch (value) {
                case 0: {
                    this.rangeString = "{" + value + "}";
                    this.syntax = Syntax.syntaxARQ;
                    break;
                }
                case 1: {
                    this.rangeString = ZERO_OR_ONE;
                    this.syntax = Syntax.syntaxSPARQL_11;
                    break;
                }
                default: {
                    this.rangeString = "{," + value + "}";
                    this.syntax = Syntax.syntaxARQ;
                }
            }
        }
    }

    public QueryStringPathRange(int start, int end) {
        this.throwExceptionIfNegative(start);
        this.throwExceptionIfNegative(end);
        if (start > end) {
            throw new IllegalArgumentException("start > end");
        }
        if (start == end) {
            this.rangeString = "{" + start + "}";
            this.syntax = Syntax.syntaxARQ;
        } else if (start == 0 && end == 1) {
            this.rangeString = ZERO_OR_ONE;
            this.syntax = Syntax.syntaxSPARQL_11;
        } else {
            this.rangeString = "{" + start + "," + end + "}";
            this.syntax = Syntax.syntaxARQ;
        }
    }

    private void throwExceptionIfNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("a negative argument was found while not allowed");
        }
    }

    public String toString() {
        return this.getRangeString();
    }
}

