/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.molgenis.vibe.core.formats.AllFieldsEquals;
import org.molgenis.vibe.core.formats.BiologicalEntity;
import org.molgenis.vibe.core.formats.BiologicalEntityCombination;

public abstract class BiologicalEntityCollection<T1 extends BiologicalEntity, T2 extends BiologicalEntity, T3 extends BiologicalEntityCombination<T1, T2>>
implements Collection<T3>,
AllFieldsEquals {
    private Map<T3, T3> combinationsMap = new HashMap<T3, T3>();
    private Map<T1, Set<T3>> combinationsByT1 = new HashMap<T1, Set<T3>>();
    private Map<T2, Set<T3>> combinationsByT2 = new HashMap<T2, Set<T3>>();

    public T3 get(T3 t3) {
        return (T3)((BiologicalEntityCombination)this.combinationsMap.get(t3));
    }

    public Set<T1> getT1() {
        return Collections.unmodifiableSet(this.combinationsByT1.keySet());
    }

    public Set<T2> getT2() {
        return Collections.unmodifiableSet(this.combinationsByT2.keySet());
    }

    public Set<T3> getT3() {
        return Collections.unmodifiableSet(this.combinationsMap.keySet());
    }

    public List<T3> getT3Ordered() {
        ArrayList<Object> orderedList = new ArrayList<Object>();
        orderedList.addAll(this.combinationsMap.keySet());
        orderedList.sort(Comparator.comparing(BiologicalEntityCombination::getT1).thenComparing(BiologicalEntityCombination::getT2));
        return orderedList;
    }

    public Set<T3> getByT1(T1 t1) {
        return this.combinationsByT1.get(t1) == null ? null : Collections.unmodifiableSet(this.combinationsByT1.get(t1));
    }

    public Set<T3> getByT2(T2 t2) {
        return this.combinationsByT2.get(t2) == null ? null : Collections.unmodifiableSet(this.combinationsByT2.get(t2));
    }

    protected BiologicalEntityCollection() {
    }

    protected BiologicalEntityCollection(Collection<? extends T3> combinations) {
        this.addAll(combinations);
    }

    @Override
    public int size() {
        return this.combinationsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.combinationsMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.combinationsMap.containsKey(o);
    }

    @Override
    public Iterator<T3> iterator() {
        return this.combinationsMap.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.combinationsMap.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.combinationsMap.keySet().toArray(a);
    }

    @Override
    public boolean add(T3 t3) {
        if (!this.combinationsMap.containsKey(t3)) {
            this.combinationsMap.put(t3, t3);
            this.addCombinationToT1Map(t3, this.combinationsByT1);
            this.addCombinationToT2Map(t3, this.combinationsByT2);
            return true;
        }
        return false;
    }

    private void addCombinationToT1Map(T3 t3, Map<T1, Set<T3>> combinationsMap) {
        Set<T3> valueSet = combinationsMap.get(((BiologicalEntityCombination)t3).getT1());
        if (valueSet == null) {
            valueSet = new HashSet<T3>();
            combinationsMap.put(((BiologicalEntityCombination)t3).getT1(), valueSet);
        }
        valueSet.add(t3);
    }

    private void addCombinationToT2Map(T3 t3, Map<T2, Set<T3>> combinationsMap) {
        Set<T3> valueSet = combinationsMap.get(((BiologicalEntityCombination)t3).getT2());
        if (valueSet == null) {
            valueSet = new HashSet<T3>();
            combinationsMap.put(((BiologicalEntityCombination)t3).getT2(), valueSet);
        }
        valueSet.add(t3);
    }

    @Override
    public boolean remove(Object o) {
        T3 object = this.combinationsMap.remove(o);
        this.combinationsByT1.values().forEach(s -> s.remove(o));
        this.combinationsByT2.values().forEach(s -> s.remove(o));
        this.removeEmptySets(this.combinationsByT1);
        this.removeEmptySets(this.combinationsByT2);
        return !Objects.isNull(object);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.combinationsMap.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T3> c) {
        boolean changed = false;
        Iterator<T3> cIterator = c.iterator();
        while (cIterator.hasNext()) {
            boolean itemAdded = this.add((T3)((BiologicalEntityCombination)cIterator.next()));
            if (!itemAdded) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.combinationsMap.keySet().removeAll(c);
        this.combinationsByT1.values().forEach(s -> s.removeAll(c));
        this.combinationsByT2.values().forEach(s -> s.removeAll(c));
        this.removeEmptySets(this.combinationsByT1);
        this.removeEmptySets(this.combinationsByT2);
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.combinationsMap.keySet().retainAll(c);
        this.combinationsByT1.values().forEach(s -> s.retainAll(c));
        this.combinationsByT2.values().forEach(s -> s.retainAll(c));
        this.removeEmptySets(this.combinationsByT1);
        this.removeEmptySets(this.combinationsByT2);
        return changed;
    }

    private void removeEmptySets(Map<? extends BiologicalEntity, Set<T3>> combinationsByKey) {
        HashSet<BiologicalEntity> keysWithEmptySet = new HashSet<BiologicalEntity>();
        for (Map.Entry<BiologicalEntity, Set<T3>> combination : combinationsByKey.entrySet()) {
            if (!combination.getValue().isEmpty()) continue;
            keysWithEmptySet.add(combination.getKey());
        }
        for (BiologicalEntity key : keysWithEmptySet) {
            combinationsByKey.remove(key);
        }
    }

    @Override
    public void clear() {
        this.combinationsMap.clear();
        this.combinationsByT1.clear();
        this.combinationsByT2.clear();
    }

    public String toString() {
        return "BiologicalEntityCollection{combinationsMap.keySet()=" + this.combinationsMap.keySet() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiologicalEntityCollection that = (BiologicalEntityCollection)o;
        return Objects.equals(this.combinationsMap, that.combinationsMap);
    }

    @Override
    public boolean allFieldsEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiologicalEntityCollection that = (BiologicalEntityCollection)o;
        if (!(Objects.equals(this.combinationsMap, that.combinationsMap) && Objects.equals(this.combinationsByT1, that.combinationsByT1) && Objects.equals(this.combinationsByT2, that.combinationsByT2))) {
            return false;
        }
        for (BiologicalEntityCombination item : this.combinationsMap.keySet()) {
            if (item.allFieldsEquals(that.combinationsMap.get(item))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.combinationsMap.keySet());
    }
}

