/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.net.URI;
import java.util.Comparator;
import java.util.Objects;
import org.molgenis.vibe.core.formats.Entity;
import org.molgenis.vibe.core.formats.EntityWithIntId;
import org.molgenis.vibe.core.formats.Evidence;

public class PubmedEvidence
extends Evidence
implements EntityWithIntId {
    public static final String ID_PREFIX = "pmid";
    private static final String ID_REGEX = "^(pmid|PMID):([0-9]+)$";
    private static final int REGEX_ID_GROUP = 2;
    private static final String URI_PREFIX = "http://identifiers.org/pubmed/";
    private int year;
    private int idInt = Integer.parseInt(this.getId());
    public static final Comparator<PubmedEvidence> RELEASE_YEAR_COMPARATOR = (o1, o2) -> {
        int diff = o2.year - o1.year;
        if (diff == 0) {
            diff = o1.idInt - o2.idInt;
        }
        return diff;
    };

    @Override
    public int getIdInt() {
        return this.idInt;
    }

    public PubmedEvidence(String id, int year) {
        super(id);
        this.year = Objects.requireNonNull(year);
    }

    public PubmedEvidence(URI uri, int year) {
        super(uri);
        this.year = Objects.requireNonNull(year);
    }

    @Override
    protected String getIdPrefix() {
        return ID_PREFIX;
    }

    @Override
    protected String getIdRegex() {
        return ID_REGEX;
    }

    @Override
    protected int getRegexIdGroup() {
        return 2;
    }

    @Override
    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public int getReleaseYear() {
        return this.year;
    }

    @Override
    public int compareTo(Entity o) {
        if (o instanceof PubmedEvidence) {
            PubmedEvidence oPubmedEvidence = (PubmedEvidence)o;
            return this.idInt - oPubmedEvidence.idInt;
        }
        return super.compareTo(o);
    }

    @Override
    public boolean allFieldsEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PubmedEvidence that = (PubmedEvidence)o;
        return super.allFieldsEquals(o) && this.year == that.year && this.idInt == that.idInt;
    }

    @Override
    public String toString() {
        return "PubmedEvidence{year=" + this.year + ' ' + super.toString() + '}';
    }
}

