/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.io.input;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.molgenis.vibe.core.io.input.ModelReader;
import org.molgenis.vibe.core.io.input.ModelReaderFactory;

public class VibeDatabase {
    private Path dbPath;
    private ModelReaderFactory modelReaderFactory;

    public VibeDatabase(Path dbPath, ModelReaderFactory modelReaderFactory) throws IOException {
        this.dbPath = Objects.requireNonNull(dbPath);
        this.modelReaderFactory = Objects.requireNonNull(modelReaderFactory);
        this.validate();
    }

    public ModelReader getModelReader() throws IOException {
        return this.modelReaderFactory.readDatabase(this.dbPath);
    }

    private void validate() throws IOException {
        if (this.modelReaderFactory.equals((Object)ModelReaderFactory.HDT)) {
            Path indexFile;
            if (!(Files.isRegularFile(this.dbPath, new LinkOption[0]) && Files.isReadable(this.dbPath) && this.dbPath.toString().toLowerCase().endsWith(".hdt"))) {
                throw new IOException("Invalid database. Please check if " + this.dbPath.getFileName() + " is a readable .hdt file.");
            }
            if (!(Files.isWritable(this.dbPath.getParent()) || Files.isRegularFile(indexFile = Paths.get(this.dbPath.toString() + ".index.v1-1", new String[0]), new LinkOption[0]) && Files.isReadable(indexFile))) {
                throw new IOException("Read-only directories require pre-made index file.");
            }
        } else {
            throw new IllegalArgumentException("Chosen ModelReaderFactory option is currently not supported as vibe database.");
        }
    }
}

