/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.ontology_processing;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.PhenotypeNetwork;
import org.molgenis.vibe.core.ontology_processing.PhenotypesRetriever;

public class MaxDistanceRetriever
extends PhenotypesRetriever {
    public MaxDistanceRetriever(OntModel model, Collection<Phenotype> inputPhenotypes, int maxDistance) {
        super(model, inputPhenotypes, maxDistance);
    }

    @Override
    public void run() {
        for (Phenotype phenotype : this.getInputPhenotypes()) {
            PhenotypeNetwork network = new PhenotypeNetwork(phenotype);
            HashSet<OntClass> startOC = new HashSet<OntClass>();
            startOC.add(this.retrievePhenotypeFromModel(phenotype));
            this.traverse(new HashSet<OntClass>(), startOC, network, 0);
            this.getPhenotypeNetworkCollection().add(network);
        }
    }

    private void traverse(Set<OntClass> previousPhenotypeOCs, Set<OntClass> currentPhenotypeOCs, PhenotypeNetwork network, int distance) {
        HashSet<OntClass> nextPhenotypeOCs = new HashSet<OntClass>();
        for (OntClass phenotypeOC : currentPhenotypeOCs) {
            if (this.skippableUri(phenotypeOC)) continue;
            this.addPhenotypeToNetwork(phenotypeOC, network, distance);
            if (distance >= this.getMaxDistance()) continue;
            nextPhenotypeOCs.addAll(phenotypeOC.listSuperClasses().toSet());
            nextPhenotypeOCs.addAll(phenotypeOC.listSubClasses().toSet());
        }
        nextPhenotypeOCs.removeAll(previousPhenotypeOCs);
        if (!nextPhenotypeOCs.isEmpty()) {
            this.traverse(currentPhenotypeOCs, nextPhenotypeOCs, network, distance + 1);
        }
    }
}

