/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core;

import java.nio.file.Path;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.molgenis.vibe.core.formats.Phenotype;
import org.molgenis.vibe.core.formats.PhenotypeNetworkCollection;
import org.molgenis.vibe.core.io.input.OntologyModelFilesReader;
import org.molgenis.vibe.core.ontology_processing.PhenotypesRetriever;
import org.molgenis.vibe.core.ontology_processing.PhenotypesRetrieverFactory;

public class PhenotypesRetrievalRunner
implements Callable<PhenotypeNetworkCollection> {
    private Path hpoOntologyFile;
    private PhenotypesRetrieverFactory phenotypesRetrieverFactory;
    private Collection<Phenotype> phenotypes;
    private Integer maxDistance;

    private void setMaxDistance(Integer maxDistance) {
        Objects.requireNonNull(maxDistance);
        if (maxDistance < 0) {
            throw new InvalidParameterException("maxDistance must be >= 0: " + maxDistance);
        }
        this.maxDistance = maxDistance;
    }

    public PhenotypesRetrievalRunner(Path hpoOntologyFile, PhenotypesRetrieverFactory phenotypesRetrieverFactory, Collection<Phenotype> phenotypes, Integer maxDistance) {
        this.hpoOntologyFile = Objects.requireNonNull(hpoOntologyFile);
        this.phenotypesRetrieverFactory = Objects.requireNonNull(phenotypesRetrieverFactory);
        this.phenotypes = Objects.requireNonNull(phenotypes);
        this.setMaxDistance(maxDistance);
    }

    @Override
    public PhenotypeNetworkCollection call() {
        try (OntologyModelFilesReader ontologyReader = new OntologyModelFilesReader(this.hpoOntologyFile.toString());){
            PhenotypesRetriever hpoRetriever = this.phenotypesRetrieverFactory.create(ontologyReader.getModel(), this.phenotypes, this.maxDistance);
            hpoRetriever.run();
            PhenotypeNetworkCollection phenotypeNetworkCollection = hpoRetriever.getPhenotypeNetworkCollection();
            return phenotypeNetworkCollection;
        }
    }
}

