/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.database_processing;

import java.util.Iterator;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;
import org.molgenis.vibe.core.database_processing.query_string_creation.QueryString;

public class QueryRunner
implements Closeable,
Iterator<QuerySolution> {
    private QueryExecution qexec;
    private ResultSet results;

    public QueryRunner(Model model, QueryString queryString) {
        Query query = QueryFactory.create((String)queryString.getQuery(), (Syntax)queryString.getSyntax());
        this.qexec = QueryExecutionFactory.create((Query)query, (Model)model);
        this.results = this.qexec.execSelect();
    }

    public ResultSet getResultSet() {
        return this.results;
    }

    @Override
    public boolean hasNext() {
        return this.results.hasNext();
    }

    @Override
    public QuerySolution next() {
        return this.results.next();
    }

    public void close() {
        this.qexec.close();
    }
}

