/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.net.URI;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.vibe.core.exceptions.InvalidStringFormatException;
import org.molgenis.vibe.core.formats.AllFieldsEquals;
import org.molgenis.vibe.core.formats.ResourceUri;

public abstract class Entity
implements ResourceUri,
Comparable<Entity>,
AllFieldsEquals {
    private String id;
    private String name;
    private URI uri;

    protected abstract String getIdPrefix();

    protected abstract String getIdRegex();

    protected abstract int getRegexIdGroup();

    protected abstract String getUriPrefix();

    public String getId() {
        return this.id;
    }

    public String getFormattedId() {
        return this.getIdPrefix() + ":" + this.id;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public Entity(String id) {
        this.id = this.retrieveIdFromString(Objects.requireNonNull(id));
        this.uri = URI.create(this.getUriPrefix() + this.id);
    }

    public Entity(URI uri) {
        this.uri = Objects.requireNonNull(uri);
        String uriString = this.uri.toString();
        this.validateUri(uriString);
        this.id = uriString.split(this.getUriPrefix())[1];
        this.retrieveIdFromString(this.getFormattedId());
    }

    public Entity(String id, String name) {
        this(id);
        this.name = Objects.requireNonNull(name);
    }

    public Entity(URI uri, String name) {
        this(uri);
        this.name = Objects.requireNonNull(name);
    }

    private void validateUri(String uriString) {
        if (!uriString.startsWith(this.getUriPrefix())) {
            throw new IllegalArgumentException("The URI \"" + uriString + "\" does not start with: " + this.getUriPrefix());
        }
        if (uriString.length() == this.getUriPrefix().length()) {
            throw new IllegalArgumentException("The URI \"" + uriString + "\" does not contain anything after the prefix.");
        }
    }

    protected String retrieveIdFromString(String fullString) throws InvalidStringFormatException {
        Matcher m = Pattern.compile(this.getIdRegex()).matcher(fullString);
        if (m.matches()) {
            return m.group(this.getRegexIdGroup());
        }
        throw new InvalidStringFormatException(fullString + " does not adhere the required format: " + this.getIdRegex());
    }

    public String toString() {
        return "Entity{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", uri=" + this.uri + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity that = (Entity)o;
        return Objects.equals(this.uri, that.uri);
    }

    @Override
    public boolean allFieldsEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Entity entity = (Entity)o;
        return Objects.equals(this.id, entity.id) && Objects.equals(this.name, entity.name) && Objects.equals(this.uri, entity.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    @Override
    public int compareTo(Entity o) {
        return this.getId().compareTo(o.getId());
    }
}

