/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.molgenis.vibe.core.formats.Disease;
import org.molgenis.vibe.core.formats.Gene;
import org.molgenis.vibe.core.formats.GeneDiseaseCollection;
import org.molgenis.vibe.core.formats.GeneDiseaseCollectionJsonSerialization;
import org.molgenis.vibe.core.formats.GeneDiseaseCombination;
import org.molgenis.vibe.core.formats.PubmedEvidence;
import org.molgenis.vibe.core.formats.Source;

public class GeneDiseaseCollectionSerializer
extends GeneDiseaseCollectionJsonSerialization
implements JsonSerializer<GeneDiseaseCollection> {
    public JsonElement serialize(GeneDiseaseCollection src, Type typeOfSrc, JsonSerializationContext context) {
        HashSet<Source> sources = new HashSet<Source>();
        JsonObject collectionObject = new JsonObject();
        collectionObject.add("combinations", (JsonElement)this.generateGeneDiseaseCombinationsArray(src, sources));
        collectionObject.add("ncbigene", (JsonElement)this.generateGenesData(src));
        collectionObject.add("umls", (JsonElement)this.generateDiseaseData(src));
        collectionObject.add("sources", (JsonElement)this.generateSourcesData(sources));
        return collectionObject;
    }

    private JsonArray generateGeneDiseaseCombinationsArray(GeneDiseaseCollection src, Set<Source> allSources) {
        JsonArray combinationsArray = new JsonArray();
        for (GeneDiseaseCombination gdc : src.getGeneDiseaseCombinationsOrdered()) {
            JsonObject combinationObject = new JsonObject();
            combinationObject.addProperty("ncbigene", gdc.getGene().getId());
            combinationObject.addProperty("umls", gdc.getDisease().getId());
            combinationObject.addProperty("score", (Number)gdc.getDisgenetScore());
            JsonArray evidenceArray = new JsonArray();
            ArrayList<Source> orderedSources = new ArrayList<Source>();
            orderedSources.addAll(gdc.getSourcesCount().keySet());
            Collections.sort(orderedSources);
            for (Source source : orderedSources) {
                allSources.add(source);
                JsonObject evidenceItemObject = new JsonObject();
                evidenceItemObject.addProperty("name", source.getName());
                evidenceItemObject.addProperty("count", (Number)gdc.getCountForSource(source));
                JsonArray pubmedEvidenceArray = new JsonArray();
                List<PubmedEvidence> evidenceList = gdc.getPubmedEvidenceForSourceSortedByReleaseDate(source);
                if (evidenceList != null) {
                    for (PubmedEvidence pubmedEvidence : evidenceList) {
                        JsonObject pubmedEvidenceObject = new JsonObject();
                        pubmedEvidenceObject.addProperty("uri", pubmedEvidence.getUri().toString());
                        pubmedEvidenceObject.addProperty("year", (Number)pubmedEvidence.getReleaseYear());
                        pubmedEvidenceArray.add((JsonElement)pubmedEvidenceObject);
                    }
                }
                evidenceItemObject.add("pubmed", (JsonElement)pubmedEvidenceArray);
                evidenceArray.add((JsonElement)evidenceItemObject);
            }
            combinationObject.add("sources", (JsonElement)evidenceArray);
            combinationsArray.add((JsonElement)combinationObject);
        }
        return combinationsArray;
    }

    private JsonObject generateGenesData(GeneDiseaseCollection src) {
        JsonObject genesObject = new JsonObject();
        for (Gene gene : src.getGenes()) {
            JsonObject singleGeneObject = new JsonObject();
            singleGeneObject.addProperty("hgnc", gene.getSymbol().getId());
            genesObject.add(gene.getId(), (JsonElement)singleGeneObject);
        }
        return genesObject;
    }

    private JsonObject generateDiseaseData(GeneDiseaseCollection src) {
        JsonObject diseasesObject = new JsonObject();
        for (Disease disease : src.getDiseases()) {
            JsonObject singleDiseaseObject = new JsonObject();
            singleDiseaseObject.addProperty("name", disease.getName());
            diseasesObject.add(disease.getId(), (JsonElement)singleDiseaseObject);
        }
        return diseasesObject;
    }

    private JsonObject generateSourcesData(Set<Source> sourcesSet) {
        JsonObject sourcesObject = new JsonObject();
        for (Source source : sourcesSet) {
            JsonObject singleSourceObject = new JsonObject();
            singleSourceObject.addProperty("fullName", source.getFullName());
            singleSourceObject.addProperty("uri", source.getUri().toString());
            singleSourceObject.addProperty("level", source.getLevel().getReadableString());
            sourcesObject.add(source.getName(), (JsonElement)singleSourceObject);
        }
        return sourcesObject;
    }
}

