/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.vibe.core.exceptions.InvalidStringFormatException;
import org.molgenis.vibe.core.formats.EnumTypeDefiner;

public enum GeneDiseaseCombinationType implements EnumTypeDefiner
{
    GENE_DISEASE("SIO_000983"),
    THERAPEUTIC("SIO_001120"),
    BIOMARKER("SIO_001121"),
    GENOMIC_ALTERATION("SIO_001350"),
    ALTERED_EXPRESSION("SIO_001123"),
    POST_TRANSLATIONAL_MODIFICATION("SIO_001124"),
    CHROMOSOMAL_REARRANGEMENT("SIO_001349"),
    GENETIC_VARIATION("SIO_001122"),
    FUSION_GENE("SIO_001348"),
    SUSCEPTIBILITY_MUTATION("SIO_001343"),
    CASUAL_MUTATION("SIO_001119"),
    MODIFYING_MUTATION("SIO_001342"),
    SOMATIC_CASUAL_MUTATION("SIO_001345"),
    GERMLINE_CASUAL_MUTATION("SIO_001344"),
    SOMATIC_MODIFYING_MUTATION("SIO_001346"),
    GERMLINE_MODIFYING_MUTATION("SIO_001347");

    public static final GeneDiseaseCombinationType ROOT;
    private static final String PREFIX = "sio:";
    private String id;

    @Override
    public String getId() {
        return this.id;
    }

    public String getFormattedId() {
        return PREFIX + this.id;
    }

    private GeneDiseaseCombinationType(String sio) {
        this.id = sio;
    }

    public static GeneDiseaseCombinationType retrieve(String sio) {
        Matcher m = Pattern.compile("^((sio|SIO):)?(SIO_[0-9]{6})$").matcher(sio);
        if (m.matches()) {
            return EnumTypeDefiner.retrieve(m.group(3), GeneDiseaseCombinationType.class);
        }
        throw new InvalidStringFormatException(sio + " does not adhere the required format: ^((sio|SIO):)?(SIO_[0-9]{6})$");
    }

    static {
        ROOT = GENE_DISEASE;
    }
}

