/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.vibe.core.formats;

import java.net.URI;
import java.util.Objects;
import org.molgenis.vibe.core.exceptions.InvalidStringFormatException;
import org.molgenis.vibe.core.formats.ResourceUri;

public class Source
implements ResourceUri,
Comparable<Source> {
    private String name;
    private Level level;
    private URI uri;

    public String getName() {
        return this.name.split(" ")[0];
    }

    public String getFullName() {
        return this.name;
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public Source(URI uri, String name, Level level) {
        this.name = Objects.requireNonNull(name);
        this.level = Objects.requireNonNull(level);
        this.uri = Objects.requireNonNull(uri);
    }

    public Source(URI uri, String name, String level) throws InvalidStringFormatException {
        this.name = Objects.requireNonNull(name);
        this.level = Level.retrieveLevelByString(level);
        this.uri = Objects.requireNonNull(uri);
    }

    public String toString() {
        return "Source{name='" + this.name + '\'' + ", level=" + (Object)((Object)this.level) + ", uri=" + this.uri + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Source source = (Source)o;
        return Objects.equals(this.uri, source.uri);
    }

    public int hashCode() {
        return Objects.hash(this.uri);
    }

    @Override
    public int compareTo(Source o) {
        return this.getFullName().compareTo(o.getFullName());
    }

    public static enum Level {
        CURATED("curated", "source_evidence_curated"),
        MODEL("model", "source_evidence_predicted"),
        LITERATURE("literature", "source_evidence_literature");

        private String readableString;
        private String disgenetVoidUri;

        public String getReadableString() {
            return this.readableString;
        }

        private Level(String readableString, String disgenetVoidUriEnd) {
            this.readableString = readableString;
            this.disgenetVoidUri = disgenetVoidUriEnd;
        }

        public static Level retrieveLevelByString(String levelString) throws InvalidStringFormatException {
            levelString = levelString.toLowerCase();
            for (Level level : Level.values()) {
                if (!levelString.equals(level.readableString) && !levelString.endsWith(level.disgenetVoidUri)) continue;
                return level;
            }
            throw new InvalidStringFormatException("Could not generate a Source.Level from given String: " + levelString);
        }
    }
}

