/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.core.miners;

import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import org.monarchinitiative.hpotextmining.core.miners.MinedTerm;

public final class SimpleMinedTerm
implements MinedTerm {
    private final int begin;
    private final int end;
    private final String termId;
    private final boolean present;

    public SimpleMinedTerm(int begin, int end, String termId, boolean present) {
        this.begin = begin;
        this.end = end;
        this.termId = termId;
        this.present = present;
    }

    public static Comparator<MinedTerm> compareByBegin() {
        return (l, r) -> ComparisonChain.start().compare(l.getBegin(), r.getBegin()).result();
    }

    @Override
    public int getBegin() {
        return this.begin;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public String getTermId() {
        return this.termId;
    }

    @Override
    public boolean isPresent() {
        return this.present;
    }

    public int hashCode() {
        int result = this.begin;
        result = 31 * result + this.end;
        result = 31 * result + this.termId.hashCode();
        result = 31 * result + (this.present ? 1 : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMinedTerm minedTerm = (SimpleMinedTerm)o;
        if (this.begin != minedTerm.begin) {
            return false;
        }
        if (this.end != minedTerm.end) {
            return false;
        }
        if (this.present != minedTerm.present) {
            return false;
        }
        return this.termId.equals(minedTerm.termId);
    }

    public String toString() {
        return "SimpleMinedTerm{begin=" + this.begin + ", end=" + this.end + ", termId='" + this.termId + '\'' + ", present=" + this.present + '}';
    }
}

