/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.core.miners.biolark;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.monarchinitiative.hpotextmining.core.miners.MinedTerm;
import org.monarchinitiative.hpotextmining.core.miners.TermMiner;
import org.monarchinitiative.hpotextmining.core.miners.TermMinerException;
import org.monarchinitiative.hpotextmining.core.miners.biolark.BiolarkResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiolarkTermMiner
implements TermMiner {
    private static final Logger LOGGER = LoggerFactory.getLogger(BiolarkTermMiner.class);
    private final URLConnection connection;

    public BiolarkTermMiner(URLConnection connection) {
        this.connection = connection;
    }

    public BiolarkTermMiner(URL server) throws IOException {
        this(server.openConnection());
    }

    public Set<MinedTerm> doMining(String query) throws TermMinerException {
        if (query == null) {
            throw new TermMinerException("Query must not be null");
        }
        StringBuilder jsonStringBuilder = new StringBuilder();
        try {
            String protocol;
            switch (protocol = this.connection.getURL().getProtocol()) {
                case "http": {
                    ((HttpURLConnection)this.connection).setRequestMethod("POST");
                    break;
                }
                case "https": {
                    ((HttpsURLConnection)this.connection).setRequestMethod("POST");
                    break;
                }
            }
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setRequestProperty("Accept", "application/json");
            this.connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
            try (OutputStreamWriter writer = new OutputStreamWriter(this.connection.getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(query);
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));){
                String line;
                while ((line = br.readLine()) != null) {
                    jsonStringBuilder.append(line);
                }
            }
        }
        catch (IOException e) {
            throw new TermMinerException("Error occurred during the connection", e);
        }
        return this.decodePayload(jsonStringBuilder.toString());
    }

    private Set<MinedTerm> decodePayload(String jsonResponse) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            CollectionType javaType = mapper.getTypeFactory().constructCollectionType(Set.class, BiolarkResult.class);
            Set results = (Set)mapper.readValue(jsonResponse, (JavaType)javaType);
            return new HashSet<MinedTerm>();
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return new HashSet<MinedTerm>();
        }
    }
}

