/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.hpotextmining.core.miners.scigraph;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import org.monarchinitiative.hpotextmining.core.miners.biolark.BiolarkResult;
import org.monarchinitiative.hpotextmining.core.miners.biolark.BiolarkToken;
import org.monarchinitiative.hpotextmining.core.miners.scigraph.SciGraphToken;

public class SciGraphResult
implements Comparable<SciGraphResult> {
    private SciGraphToken token;
    private int start;
    private int end;

    @JsonCreator
    public SciGraphResult(@JsonProperty(value="token") SciGraphToken token, @JsonProperty(value="start") int start, @JsonProperty(value="end") int end) {
        this.token = token;
        this.start = start;
        this.end = end;
    }

    public static BiolarkResult toBiolarkResult(SciGraphResult m, String query) {
        String id = m.token.getId();
        String label = m.token.getTerms().get(0);
        HashSet<String> synonyms = new HashSet<String>();
        BiolarkToken biolarkTerm = new BiolarkToken(id, label, synonyms);
        return new BiolarkResult(m.start, m.end, m.end - m.start, query.substring(m.start, m.end), m.token.getId().split(":")[0], biolarkTerm, false);
    }

    public SciGraphToken getToken() {
        return this.token;
    }

    public void setToken(SciGraphToken token) {
        this.token = token;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SciGraphResult)) {
            return false;
        }
        SciGraphResult o = (SciGraphResult)other;
        return this.token.equals(o.token) && this.start == o.start && this.end == o.end;
    }

    public int hashCode() {
        int hash = 31 * this.token.hashCode() + this.start;
        hash = 31 * hash + this.end;
        return hash;
    }

    @Override
    public int compareTo(SciGraphResult o) {
        return this.start - o.start;
    }
}

