/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.annotations.hpo;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;

public class HpoAnnotationModel {
    private final String basename;
    private final List<HpoAnnotationEntry> entryList;
    private final Database database;

    public String getBasename() {
        return this.basename;
    }

    public HpoAnnotationModel(String name, List<HpoAnnotationEntry> entries) {
        this.basename = name;
        this.entryList = ImmutableList.copyOf(entries);
        this.database = this.basename.contains("OMIM") ? Database.OMIM : (this.basename.contains("DECIPHER") ? Database.DECIPHER : Database.UNKNOWN);
    }

    public boolean isOMIM() {
        return this.database.equals((Object)Database.OMIM);
    }

    public boolean isDECIPHER() {
        return this.database.equals((Object)Database.DECIPHER);
    }

    public List<HpoAnnotationEntry> getEntryList() {
        return this.entryList;
    }

    public int getNumberOfAnnotations() {
        return this.entryList.size();
    }

    private static enum Database {
        OMIM,
        DECIPHER,
        UNKNOWN;

    }
}

