/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.hpo;

import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.formats.hpo.HpoFrequencyTermIds;
import org.monarchinitiative.phenol.ontology.data.TermId;

public enum HpoFrequency {
    ALWAYS_PRESENT("Always present (HP:??)"),
    VERY_FREQUENT("Very frequent (HP:??"),
    FREQUENT("Frequent (HP:??"),
    OCCASIONAL("Occasional (HP:??)"),
    VERY_RARE("Very rare (HP:??)"),
    EXCLUDED("Excluded (HP:??)");

    private final String name;

    private HpoFrequency(String n2) {
        this.name = n2;
    }

    public double lowerBound() {
        switch (this) {
            case ALWAYS_PRESENT: {
                return 1.0;
            }
            case EXCLUDED: {
                return 0.0;
            }
            case FREQUENT: {
                return 0.05;
            }
            case OCCASIONAL: {
                return 0.01;
            }
            case VERY_FREQUENT: {
                return 0.3;
            }
            case VERY_RARE: {
                return 0.01;
            }
        }
        return ALWAYS_PRESENT.lowerBound();
    }

    public double mean() {
        switch (this) {
            case ALWAYS_PRESENT: {
                return 1.0;
            }
            case EXCLUDED: {
                return 0.0;
            }
            case FREQUENT: {
                return 0.545;
            }
            case OCCASIONAL: {
                return 0.16999999999999998;
            }
            case VERY_FREQUENT: {
                return 0.895;
            }
            case VERY_RARE: {
                return 0.025;
            }
        }
        return ALWAYS_PRESENT.mean();
    }

    public double upperBound() {
        switch (this) {
            case ALWAYS_PRESENT: {
                return 1.0;
            }
            case EXCLUDED: {
                return 0.0;
            }
            case FREQUENT: {
                return 0.29;
            }
            case OCCASIONAL: {
                return 0.04;
            }
            case VERY_FREQUENT: {
                return 0.79;
            }
            case VERY_RARE: {
                return 0.04;
            }
        }
        return ALWAYS_PRESENT.upperBound();
    }

    public TermId toTermId() {
        switch (this) {
            case ALWAYS_PRESENT: {
                return HpoFrequencyTermIds.ALWAYS_PRESENT;
            }
            case EXCLUDED: {
                return HpoFrequencyTermIds.EXCLUDED;
            }
            case FREQUENT: {
                return HpoFrequencyTermIds.FREQUENT;
            }
            case OCCASIONAL: {
                return HpoFrequencyTermIds.OCCASIONAL;
            }
            case VERY_FREQUENT: {
                return HpoFrequencyTermIds.VERY_FREQUENT;
            }
        }
        return HpoFrequencyTermIds.ALWAYS_PRESENT;
    }

    public static HpoFrequency fromTermId(TermId termId) {
        switch (termId.getValue()) {
            case "HP:0040280": {
                return ALWAYS_PRESENT;
            }
            case "HP:0040281": {
                return VERY_FREQUENT;
            }
            case "HP:0040282": {
                return FREQUENT;
            }
            case "HP:0040283": {
                return OCCASIONAL;
            }
            case "HP:0040284": {
                return VERY_RARE;
            }
            case "HP:0040285": {
                return EXCLUDED;
            }
        }
        throw new PhenolRuntimeException("TermId " + termId + " is not a valid frequency sub ontology term ID");
    }

    public static HpoFrequency fromPercent(int percent) {
        if (percent < 1) {
            return EXCLUDED;
        }
        if (percent < 5) {
            return VERY_RARE;
        }
        if (percent < 30) {
            return OCCASIONAL;
        }
        if (percent < 80) {
            return FREQUENT;
        }
        if (percent < 100) {
            return VERY_FREQUENT;
        }
        return ALWAYS_PRESENT;
    }

    public String toString() {
        return this.name;
    }
}

