/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.hpo;

import com.google.common.collect.ComparisonChain;
import org.monarchinitiative.phenol.ontology.data.TermAnnotation;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class HpoGeneAnnotation
implements TermAnnotation {
    private static final long serialVersionUID = 2L;
    private final int entrezGeneId;
    private final String entrezGeneSymbol;
    private final String hpoTermName;
    private final TermId hpoTermId;

    public HpoGeneAnnotation(int entrezGeneId, String entrezGeneSymbol, String hpoTermName, TermId hpoTermId) {
        this.entrezGeneId = entrezGeneId;
        this.entrezGeneSymbol = entrezGeneSymbol;
        this.hpoTermName = hpoTermName;
        this.hpoTermId = hpoTermId;
    }

    public int getEntrezGeneId() {
        return this.entrezGeneId;
    }

    public String getEntrezGeneSymbol() {
        return this.entrezGeneSymbol;
    }

    public String getTermName() {
        return this.hpoTermName;
    }

    @Override
    public TermId getTermId() {
        return this.hpoTermId;
    }

    @Override
    public TermId getLabel() {
        return TermId.of(String.format("NCBIGene:%d", this.entrezGeneId));
    }

    public String toString() {
        return "HPOGeneAnnotation [entrezGeneId=" + this.entrezGeneId + ", entrezGeneSymbol=" + this.entrezGeneSymbol + ", termName=" + this.hpoTermName + ", termId=" + this.hpoTermId + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entrezGeneId;
        result = 31 * result + (this.entrezGeneSymbol == null ? 0 : this.entrezGeneSymbol.hashCode());
        result = 31 * result + (this.hpoTermId == null ? 0 : this.hpoTermId.hashCode());
        result = 31 * result + (this.hpoTermName == null ? 0 : this.hpoTermName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HpoGeneAnnotation other = (HpoGeneAnnotation)obj;
        if (this.entrezGeneId != other.entrezGeneId) {
            return false;
        }
        if (this.entrezGeneSymbol == null ? other.entrezGeneSymbol != null : !this.entrezGeneSymbol.equals(other.entrezGeneSymbol)) {
            return false;
        }
        if (this.hpoTermId == null ? other.hpoTermId != null : !this.hpoTermId.equals(other.hpoTermId)) {
            return false;
        }
        return !(this.hpoTermName == null ? other.hpoTermName != null : !this.hpoTermName.equals(other.hpoTermName));
    }

    @Override
    public int compareTo(TermAnnotation o) {
        if (!(o instanceof HpoGeneAnnotation)) {
            throw new RuntimeException("Cannot compare " + o + " to a HpoGeneAnnotation");
        }
        HpoGeneAnnotation that = (HpoGeneAnnotation)o;
        return ComparisonChain.start().compare(this.entrezGeneId, that.entrezGeneId).compare((Comparable)((Object)this.entrezGeneSymbol), (Comparable)((Object)that.entrezGeneSymbol)).compare((Comparable)((Object)this.hpoTermName), (Comparable)((Object)that.hpoTermName)).compare((Comparable)this.hpoTermId, (Comparable)that.hpoTermId).result();
    }
}

