/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.hpo.category;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.monarchinitiative.phenol.formats.hpo.category.HpoCategory;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoCategoryMap {
    private final TermId[] termIdList = new TermId[]{INHERITANCE_ID, ABNORMAL_CELLULAR_ID, BLOOD_ID, CONNECTIVE_TISSUE_ID, HEAD_AND_NECK_ID, LIMBS_ID, METABOLISM_ID, PRENATAL_ID, BREAST_ID, CARDIOVASCULAR_ID, DIGESTIVE_ID, EAR_ID, ENDOCRINE_ID, EYE_ID, GENITOURINARY_ID, IMMUNOLOGY_ID, INTEGUMENT_ID, MUSCLE_ID, NERVOUS_SYSTEM_ID, RESPIRATORY_ID, SKELETAL_ID, THORACIC_CAVITY_ID, VOICE_ID, GROWTH_ID, CONSTITUTIONAL_ID, NEOPLASM_ID};
    private final ImmutableMap<TermId, HpoCategory> categorymap;
    private static final TermId INHERITANCE_ID = TermId.of("HP:0000005");
    private static final TermId ABNORMAL_CELLULAR_ID = TermId.of("HP:0025354");
    private static final TermId BLOOD_ID = TermId.of("HP:0001871");
    private static final TermId CONNECTIVE_TISSUE_ID = TermId.of("HP:0003549");
    private static final TermId HEAD_AND_NECK_ID = TermId.of("HP:0000152");
    private static final TermId LIMBS_ID = TermId.of("HP:0040064");
    private static final TermId METABOLISM_ID = TermId.of("HP:0001939");
    private static final TermId PRENATAL_ID = TermId.of("HP:0001197");
    private static final TermId BREAST_ID = TermId.of("HP:0000769");
    private static final TermId CARDIOVASCULAR_ID = TermId.of("HP:0001626");
    private static final TermId DIGESTIVE_ID = TermId.of("HP:0025031");
    private static final TermId EAR_ID = TermId.of("HP:0000598");
    private static final TermId ENDOCRINE_ID = TermId.of("HP:0000818");
    private static final TermId EYE_ID = TermId.of("HP:0000478");
    private static final TermId GENITOURINARY_ID = TermId.of("HP:0000119");
    private static final TermId IMMUNOLOGY_ID = TermId.of("HP:0002715");
    private static final TermId INTEGUMENT_ID = TermId.of("HP:0001574");
    private static final TermId MUSCLE_ID = TermId.of("HP:0003011");
    private static final TermId NERVOUS_SYSTEM_ID = TermId.of("HP:0000707");
    private static final TermId RESPIRATORY_ID = TermId.of("HP:0002086");
    private static final TermId SKELETAL_ID = TermId.of("HP:0000924");
    private static final TermId THORACIC_CAVITY_ID = TermId.of("HP:0045027");
    private static final TermId VOICE_ID = TermId.of("HP:0001608");
    private static final TermId CONSTITUTIONAL_ID = TermId.of("HP:0025142");
    private static final TermId GROWTH_ID = TermId.of("HP:0001507");
    private static final TermId NEOPLASM_ID = TermId.of("HP:0002664");

    public HpoCategoryMap() {
        ImmutableMap.Builder mapbuilder = new ImmutableMap.Builder();
        HpoCategory inheritanceCategory = new HpoCategory(INHERITANCE_ID, "Inheritance");
        mapbuilder.put((Object)INHERITANCE_ID, (Object)inheritanceCategory);
        HpoCategory abnCellCategory = new HpoCategory(ABNORMAL_CELLULAR_ID, "Cellular phenotype");
        mapbuilder.put((Object)ABNORMAL_CELLULAR_ID, (Object)abnCellCategory);
        HpoCategory abnBlood = new HpoCategory(BLOOD_ID, "Blood and blood-forming tissues");
        mapbuilder.put((Object)abnBlood.getTid(), (Object)abnBlood);
        HpoCategory abnConnTiss = new HpoCategory(CONNECTIVE_TISSUE_ID, "Connective tissue");
        mapbuilder.put((Object)abnConnTiss.getTid(), (Object)abnConnTiss);
        HpoCategory headNeckCat = new HpoCategory(HEAD_AND_NECK_ID, "Head and neck");
        mapbuilder.put((Object)HEAD_AND_NECK_ID, (Object)headNeckCat);
        HpoCategory limbCat = new HpoCategory(LIMBS_ID, "Limbs");
        mapbuilder.put((Object)LIMBS_ID, (Object)limbCat);
        HpoCategory metabolismCat = new HpoCategory(METABOLISM_ID, "Metabolism/Laboratory abnormality");
        mapbuilder.put((Object)METABOLISM_ID, (Object)metabolismCat);
        HpoCategory prenatalCat = new HpoCategory(PRENATAL_ID, "Prenatal and Birth");
        mapbuilder.put((Object)PRENATAL_ID, (Object)prenatalCat);
        HpoCategory breastCat = new HpoCategory(BREAST_ID, "Breast");
        mapbuilder.put((Object)BREAST_ID, (Object)breastCat);
        HpoCategory cardiovascularCat = new HpoCategory(CARDIOVASCULAR_ID, "Cardiovascular");
        mapbuilder.put((Object)CARDIOVASCULAR_ID, (Object)cardiovascularCat);
        HpoCategory digestiveCat = new HpoCategory(DIGESTIVE_ID, "Digestive System");
        mapbuilder.put((Object)DIGESTIVE_ID, (Object)digestiveCat);
        HpoCategory earCat = new HpoCategory(EAR_ID, "Ear");
        mapbuilder.put((Object)EAR_ID, (Object)earCat);
        HpoCategory endocrineCat = new HpoCategory(ENDOCRINE_ID, "Endocrine");
        mapbuilder.put((Object)ENDOCRINE_ID, (Object)endocrineCat);
        HpoCategory eyeCat = new HpoCategory(EYE_ID, "Eye");
        mapbuilder.put((Object)EYE_ID, (Object)eyeCat);
        HpoCategory guCat = new HpoCategory(GENITOURINARY_ID, "Genitourinary system");
        mapbuilder.put((Object)GENITOURINARY_ID, (Object)guCat);
        HpoCategory immuneCat = new HpoCategory(IMMUNOLOGY_ID, "Immunology");
        mapbuilder.put((Object)IMMUNOLOGY_ID, (Object)immuneCat);
        HpoCategory integumentCat = new HpoCategory(INTEGUMENT_ID, "Skin, Hair, and Nails");
        mapbuilder.put((Object)INTEGUMENT_ID, (Object)integumentCat);
        HpoCategory muscleCat = new HpoCategory(MUSCLE_ID, "Musculature");
        mapbuilder.put((Object)MUSCLE_ID, (Object)muscleCat);
        HpoCategory nervousCat = new HpoCategory(NERVOUS_SYSTEM_ID, "Nervous System");
        mapbuilder.put((Object)NERVOUS_SYSTEM_ID, (Object)nervousCat);
        HpoCategory respiratoryCat = new HpoCategory(RESPIRATORY_ID, "Respiratory System");
        mapbuilder.put((Object)RESPIRATORY_ID, (Object)respiratoryCat);
        HpoCategory skeletalCat = new HpoCategory(SKELETAL_ID, "Skeletal system");
        mapbuilder.put((Object)SKELETAL_ID, (Object)skeletalCat);
        HpoCategory thoracicCat = new HpoCategory(THORACIC_CAVITY_ID, "Thoracic cavity");
        mapbuilder.put((Object)THORACIC_CAVITY_ID, (Object)thoracicCat);
        HpoCategory voiceCat = new HpoCategory(VOICE_ID, "Voice");
        mapbuilder.put((Object)VOICE_ID, (Object)voiceCat);
        HpoCategory constitutionalCat = new HpoCategory(CONSTITUTIONAL_ID, "Constitutional Symptom");
        mapbuilder.put((Object)CONSTITUTIONAL_ID, (Object)constitutionalCat);
        HpoCategory growthCat = new HpoCategory(GROWTH_ID, "Growth");
        mapbuilder.put((Object)GROWTH_ID, (Object)growthCat);
        HpoCategory neoplasmCat = new HpoCategory(NEOPLASM_ID, "Neoplasm");
        mapbuilder.put((Object)NEOPLASM_ID, (Object)neoplasmCat);
        this.categorymap = mapbuilder.build();
    }

    public void addAnnotatedTerm(TermId tid, Ontology ontology) {
        try {
            HpoCategory cat = this.getCategory(tid, ontology);
            if (cat == null) {
                System.err.println("Could not get category for " + ontology.getTermMap().get(tid).getName());
                return;
            }
            cat.addAnnotatedTerm(tid);
        }
        catch (Exception e) {
            System.err.println(String.format("Exception trying to find category for %s", ontology.getTermMap().get(tid).getName()));
            e.printStackTrace();
        }
    }

    public void addAnnotatedTerms(List<TermId> tidlist, Ontology ontology) {
        for (TermId tid : tidlist) {
            this.addAnnotatedTerm(tid, ontology);
        }
    }

    private Set<TermId> getAncestorCategories(Ontology ontology, TermId childTermId) {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        ArrayDeque<TermId> stack = new ArrayDeque<TermId>();
        stack.push(childTermId);
        while (!stack.isEmpty()) {
            TermId tid = (TermId)stack.pop();
            Set<TermId> parents = OntologyAlgorithm.getParentTerms(ontology, tid, false);
            for (TermId p : parents) {
                if (this.categorymap.containsKey((Object)p)) {
                    builder.add((Object)p);
                    continue;
                }
                stack.add(p);
            }
        }
        return builder.build();
    }

    private HpoCategory getCategory(TermId tid, Ontology ontology) {
        ArrayList activeCategoryList = new ArrayList();
        if (tid == null) {
            System.err.println("Warning, tid was null...");
            return null;
        }
        Set<TermId> ancs = this.getAncestorCategories(ontology, tid);
        return this.getPrioritizedCategory(ancs);
    }

    private HpoCategory getPrioritizedCategory(Set<TermId> catlist) {
        for (TermId hpocat : catlist) {
            if (!hpocat.equals(NEOPLASM_ID)) continue;
            return (HpoCategory)this.categorymap.get((Object)hpocat);
        }
        Iterator<TermId> iterator = catlist.iterator();
        if (iterator.hasNext()) {
            TermId c = iterator.next();
            return (HpoCategory)this.categorymap.get((Object)c);
        }
        return null;
    }

    private TermId getPrioritizedTid(Set<TermId> ancestors) {
        for (TermId id : ancestors) {
            if (!id.equals(NEOPLASM_ID)) continue;
            return NEOPLASM_ID;
        }
        return ancestors.iterator().next();
    }

    public List<HpoCategory> getActiveCategoryList() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (TermId tid : this.termIdList) {
            HpoCategory cat = (HpoCategory)this.categorymap.get((Object)tid);
            if (!cat.hasAnnotation()) continue;
            builder.add((Object)cat);
        }
        return builder.build();
    }
}

