/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.mpo;

import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.formats.mpo.MpMarkerType;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MpGene {
    private final String geneSymbol;
    private final MpMarkerType markerType;
    private final TermId mgiId;

    private MpGene(TermId mgiId, String geneSymbol, MpMarkerType markerType) {
        this.mgiId = mgiId;
        this.geneSymbol = geneSymbol;
        this.markerType = markerType;
    }

    public static MpGene createMpGene(TermId mgiId, String geneSymbol, String markerType) throws PhenolException {
        MpMarkerType marker = MpMarkerType.string2enum(markerType);
        return new MpGene(mgiId, geneSymbol, marker);
    }

    public String getGeneSymbol() {
        return this.geneSymbol;
    }

    public MpMarkerType getMarkerType() {
        return this.markerType;
    }

    public TermId getMgiGeneId() {
        return this.mgiId;
    }

    public String toString() {
        return "MpGene{mgiId: " + this.mgiId + ", geneSymbol: " + this.geneSymbol + ", markerType: " + (Object)((Object)this.markerType) + '}';
    }
}

