/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.formats.mpo;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.monarchinitiative.phenol.formats.mpo.MpAnnotation;
import org.monarchinitiative.phenol.formats.mpo.MpModel;
import org.monarchinitiative.phenol.formats.mpo.MpModifier;
import org.monarchinitiative.phenol.formats.mpo.MpSimpleModel;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpGeneModel
extends MpModel {
    private static final Logger logger = LoggerFactory.getLogger(MpGeneModel.class);
    private List<TermId> genotypes;

    public MpGeneModel(TermId markerId, Ontology mpoOnt, boolean filterAncestors, MpSimpleModel ... modelList) {
        this.init(markerId, modelList);
    }

    public MpGeneModel(TermId markerId, Ontology mpoOnt, boolean filterAncestors, List<MpSimpleModel> modelList) {
        this.init(markerId, modelList.toArray(new MpSimpleModel[0]));
    }

    private void init(TermId markerId, MpSimpleModel[] models) {
        this.markerId = markerId;
        this.mergeGenotypesAndPhenotypes(models);
    }

    private void mergeGenotypesAndPhenotypes(MpSimpleModel[] models) {
        HashMap annotsByMpId = new HashMap();
        ImmutableList.Builder annotsBuilder = new ImmutableList.Builder();
        ImmutableList.Builder genotypesBuilder = new ImmutableList.Builder();
        for (MpSimpleModel model : models) {
            genotypesBuilder.add((Object)model.getGenotypeId());
            for (MpAnnotation annot : model.getPhenotypicAbnormalities()) {
                TermId mpId = annot.getTermId();
                annotsByMpId.putIfAbsent(mpId, new HashSet());
                ((Set)annotsByMpId.get(mpId)).add(annot);
            }
        }
        ImmutableList.Builder listbuilder = new ImmutableList.Builder();
        for (TermId tid : annotsByMpId.keySet()) {
            HashSet<String> pmids = new HashSet<String>();
            HashSet<MpModifier> modifierSet = new HashSet<MpModifier>();
            Set setOfMap = (Set)annotsByMpId.get(tid);
            for (MpAnnotation map : setOfMap) {
                pmids.addAll(map.getPmidSet());
                modifierSet.addAll(map.getModifiers());
            }
            MpAnnotation mpa = new MpAnnotation.Builder(tid, pmids).modifiers(modifierSet).build();
            listbuilder.add((Object)mpa);
        }
        this.phenotypicAbnormalities = listbuilder.build();
        this.genotypes = genotypesBuilder.build();
    }

    static List<MpGeneModel> createGeneModelList(List<MpSimpleModel> simpleModelList, Ontology ontology, boolean filterAncestors) {
        HashMap<TermId, List> modelsByGene = new HashMap<TermId, List>();
        ImmutableList.Builder returnListBuilder = new ImmutableList.Builder();
        for (MpSimpleModel model : simpleModelList) {
            TermId geneticMarker = model.getMarkerId();
            modelsByGene.putIfAbsent(geneticMarker, new ArrayList());
            List matchingModels = (List)modelsByGene.get(geneticMarker);
            matchingModels.add(model);
        }
        modelsByGene.forEach((k, v) -> returnListBuilder.add((Object)new MpGeneModel((TermId)k, ontology, filterAncestors, (List<MpSimpleModel>)v)));
        return returnListBuilder.build();
    }
}

