/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.graph.algo;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.graph.algo.AbstractGraphVertexStartFromVertexTraversal;
import org.monarchinitiative.phenol.graph.algo.NeighborSelector;
import org.monarchinitiative.phenol.graph.algo.VertexVisitor;

public final class BreadthFirstSearch<V extends Comparable<V>, E extends IdLabeledEdge>
extends AbstractGraphVertexStartFromVertexTraversal<V, E, DefaultDirectedGraph<V, E>> {
    @Override
    protected void startFromImpl(DefaultDirectedGraph<V, E> g, V v, VertexVisitor<V, E> visitor, NeighborSelector<V, E> selector) {
        HashSet<Comparable> seen = new HashSet<Comparable>();
        ArrayDeque<Object> dequeue = new ArrayDeque<Object>();
        dequeue.addLast(v);
        while (!dequeue.isEmpty()) {
            Comparable vertex = (Comparable)dequeue.pollFirst();
            if (seen.contains(vertex)) continue;
            seen.add(vertex);
            if (!visitor.visit(g, vertex)) break;
            Iterator<Comparable> it = selector.nextFrom(g, vertex);
            while (it.hasNext()) {
                dequeue.add(it.next());
            }
        }
    }
}

