/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.graph.algo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.graph.algo.ForwardNeighborSelector;
import org.monarchinitiative.phenol.graph.algo.GraphNotDagException;
import org.monarchinitiative.phenol.graph.algo.GraphVertexAllIteration;
import org.monarchinitiative.phenol.graph.algo.NeighborSelector;
import org.monarchinitiative.phenol.graph.algo.ReverseNeighborSelector;
import org.monarchinitiative.phenol.graph.algo.VertexVisitor;

public final class TopologicalSorting<V extends Comparable<V>, E extends IdLabeledEdge, G extends DefaultDirectedGraph<V, E>>
implements GraphVertexAllIteration<V, E, G> {
    @Override
    public void startForward(G g, VertexVisitor<V, E> visitor) {
        ForwardNeighborSelector neighborSelector = new ForwardNeighborSelector();
        this.startImpl(g, visitor, neighborSelector);
    }

    @Override
    public void startReverse(G g, VertexVisitor<V, E> visitor) {
        ReverseNeighborSelector neighborSelector = new ReverseNeighborSelector();
        this.startImpl(g, visitor, neighborSelector);
    }

    private void startImpl(G g, VertexVisitor<V, E> visitor, NeighborSelector<V, E> selector) {
        HashSet tmpMarked = new HashSet();
        HashSet unmarked = new HashSet(g.vertexSet());
        while (!unmarked.isEmpty()) {
            Comparable v = (Comparable)unmarked.iterator().next();
            this.startFromImpl(g, unmarked, tmpMarked, v, visitor, selector);
        }
    }

    private void startFromImpl(G g, Set<V> unmarked, Set<V> tmpMarked, V v, VertexVisitor<V, E> visitor, NeighborSelector<V, E> selector) {
        if (tmpMarked.contains(v)) {
            throw new GraphNotDagException("Graph is not a DAG");
        }
        if (unmarked.contains(v)) {
            tmpMarked.add(v);
            Iterator<V> nextVertices = selector.nextFrom((DefaultDirectedGraph<V, E>)g, v);
            while (nextVertices.hasNext()) {
                this.startFromImpl(g, unmarked, tmpMarked, (Comparable)nextVertices.next(), visitor, selector);
            }
            unmarked.remove(v);
            tmpMarked.remove(v);
            if (!visitor.visit((DefaultDirectedGraph<V, E>)g, v)) {
                return;
            }
        }
    }
}

