/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.algo;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InformationContentComputation {
    private static final Logger LOGGER = LoggerFactory.getLogger(InformationContentComputation.class);
    private final Ontology ontology;

    public InformationContentComputation(Ontology ontology) {
        this.ontology = ontology;
    }

    public Map<TermId, Double> computeInformationContent(Map<TermId, Collection<TermId>> termLabels) {
        LOGGER.info("Computing IC of {} terms using {} labels...", (Object)this.ontology.countAllTerms(), (Object)termLabels.values().stream().mapToInt(Collection::size).sum());
        TermId root = this.ontology.getRootTermId();
        HashMap<TermId, Integer> termToFrequency = new HashMap<TermId, Integer>();
        for (TermId termId : this.ontology.getNonObsoleteTermIds()) {
            termToFrequency.put(termId, 0);
        }
        for (Map.Entry entry : termLabels.entrySet()) {
            termToFrequency.put((TermId)entry.getKey(), ((Collection)entry.getValue()).size());
        }
        int maxFreq = (Integer)termToFrequency.get(root);
        Map<TermId, Double> map = this.caculateInformationContent(maxFreq, termToFrequency);
        int countIcZero = 0;
        double dummyIc = -Math.log(1.0 / (double)maxFreq);
        for (Term t : this.ontology.getTerms()) {
            if (t.isObsolete() || termToFrequency.containsKey(t.getId())) continue;
            ++countIcZero;
            map.put(t.getId(), dummyIc);
        }
        if (countIcZero > 0) {
            LOGGER.warn("Frequency of {} non-obsolete terms was zero! Their IC has been set to {} =  - log(1 / {}).", new Object[]{countIcZero, dummyIc, maxFreq});
        }
        LOGGER.info("Computing IC is complete.");
        return map;
    }

    private Map<TermId, Double> caculateInformationContent(double maxFreq, Map<TermId, Integer> termToFrequency) {
        HashMap<TermId, Double> termToIc = new HashMap<TermId, Double>();
        for (Map.Entry<TermId, Integer> e : termToFrequency.entrySet()) {
            double probability = (double)e.getValue().intValue() / maxFreq;
            double informationContent = e.getValue() > 0 ? -Math.log(probability) : 0.0;
            termToIc.put(e.getKey(), informationContent);
        }
        return termToIc;
    }

    public static TermId mostInformativeCommonAncestor(TermId t1, TermId t2, Ontology ontology, Map<TermId, Double> term2ic) {
        if (t1.equals(t2)) {
            return t1;
        }
        Set<TermId> anc1 = ontology.getAncestorTermIds(t1, false);
        if (anc1.contains(t2)) {
            return t2;
        }
        Set<TermId> anc2 = ontology.getAncestorTermIds(t2, false);
        if (anc2.contains(t1)) {
            return t1;
        }
        Sets.SetView intersection = Sets.intersection(anc1, anc2);
        TermId mica = null;
        double maxIC = -1.0;
        ArrayDeque<TermId> stack = new ArrayDeque<TermId>();
        stack.push(t1);
        while (!stack.isEmpty()) {
            double ic;
            TermId t = (TermId)stack.pop();
            if (intersection.contains((Object)t) && (ic = term2ic.get(t).doubleValue()) > maxIC) {
                mica = t;
                maxIC = ic;
            }
            for (TermId p : ontology.getParentTermIds(t)) {
                stack.push(p);
            }
        }
        return mica;
    }
}

