/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.algo;

import com.google.common.collect.ImmutableSortedSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.graph.algo.TopologicalSorting;
import org.monarchinitiative.phenol.graph.algo.VertexVisitor;
import org.monarchinitiative.phenol.graph.util.GraphUtil;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public final class ShortestPathTable {
    private static final int DISTANCE_INFINITY = -1;
    private final int termIdCount;
    private final HashMap<TermId, Integer> termIdToIdx;
    private final int[] distances;

    public ShortestPathTable(Ontology ontology) {
        this.termIdCount = ontology.getNonObsoleteTermIds().size();
        this.distances = new int[this.termIdCount * this.termIdCount];
        this.termIdToIdx = new HashMap(this.termIdCount);
        int i = 0;
        for (TermId termId : ImmutableSortedSet.copyOf(ontology.getNonObsoleteTermIds())) {
            this.termIdToIdx.put(termId, i++);
        }
        this.precomputeDistances(ontology);
    }

    private void precomputeDistances(Ontology ontology) {
        for (int i = 0; i < this.distances.length; ++i) {
            this.distances[i] = -1;
        }
        new TopologicalSorting<TermId, IdLabeledEdge, DefaultDirectedGraph<TermId, IdLabeledEdge>>().startForward(ontology.getGraph(), new BuildDistanceTableVertexVisitor());
    }

    private void setDistance(TermId source, TermId dest, int distance) {
        Integer idxSource = this.termIdToIdx.get(source);
        Integer idxDest = this.termIdToIdx.get(dest);
        this.distances[idxSource.intValue() * this.termIdCount + idxDest.intValue()] = distance;
    }

    public int getDistance(TermId source, TermId dest) {
        Integer idxSource = this.termIdToIdx.get(source);
        Integer idxDest = this.termIdToIdx.get(dest);
        if (idxSource == null || idxDest == null) {
            return -1;
        }
        return this.distances[idxSource * this.termIdCount + idxDest];
    }

    public int getDistanceSymmetric(TermId source, TermId dest) {
        int dist = this.getDistance(source, dest);
        if (dist != -1) {
            return dist;
        }
        return this.getDistance(dest, source);
    }

    private class BuildDistanceTableVertexVisitor
    implements VertexVisitor<TermId, IdLabeledEdge> {
        private final Set<TermId> seen = new HashSet<TermId>();

        private BuildDistanceTableVertexVisitor() {
        }

        @Override
        public boolean visit(DefaultDirectedGraph<TermId, IdLabeledEdge> g, TermId termId) {
            ShortestPathTable.this.setDistance(termId, termId, 0);
            for (TermId destTermId : this.seen) {
                int minDist = -1;
                Iterator<TermId> viaIter = GraphUtil.viaOutEdgeIterator(g, termId);
                while (viaIter.hasNext()) {
                    TermId viaTermId = viaIter.next();
                    int tmpDist = ShortestPathTable.this.getDistance(viaTermId, destTermId);
                    if (tmpDist == -1) continue;
                    int candDist = tmpDist + 1;
                    if (minDist != -1 && candDist >= minDist) continue;
                    minDist = candDist;
                }
                if (minDist == -1) continue;
                ShortestPathTable.this.setDistance(termId, destTermId, minDist);
            }
            this.seen.add(termId);
            return true;
        }
    }
}

