/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.graph.IdLabeledEdge;
import org.monarchinitiative.phenol.graph.algo.BreadthFirstSearch;
import org.monarchinitiative.phenol.graph.util.CompatibilityChecker;
import org.monarchinitiative.phenol.graph.util.GraphUtil;
import org.monarchinitiative.phenol.ontology.algo.OntologyTerms;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Relationship;
import org.monarchinitiative.phenol.ontology.data.RelationshipType;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableOntology
implements Ontology {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = LoggerFactory.getLogger(ImmutableOntology.class);
    private final ImmutableSortedMap<String, String> metaInfo;
    private final DefaultDirectedGraph<TermId, IdLabeledEdge> graph;
    private final TermId rootTermId;
    private final ImmutableMap<TermId, Term> termMap;
    private final ImmutableSet<TermId> nonObsoleteTermIds;
    private final ImmutableSet<TermId> obsoleteTermIds;
    private final ImmutableSet<TermId> allTermIds;
    private final ImmutableMap<Integer, Relationship> relationMap;
    private final ImmutableMap<TermId, ImmutableSet<TermId>> precomputedAncestors;

    public ImmutableOntology(ImmutableSortedMap<String, String> metaInfo, DefaultDirectedGraph<TermId, IdLabeledEdge> graph, TermId rootTermId, Collection<TermId> nonObsoleteTermIds, Collection<TermId> obsoleteTermIds, ImmutableMap<TermId, Term> termMap, ImmutableMap<Integer, Relationship> relationMap) {
        this.metaInfo = metaInfo;
        this.graph = graph;
        this.rootTermId = rootTermId;
        this.termMap = termMap;
        this.nonObsoleteTermIds = ImmutableSet.copyOf(nonObsoleteTermIds);
        this.obsoleteTermIds = ImmutableSet.copyOf(obsoleteTermIds);
        this.allTermIds = ImmutableSet.copyOf((Collection)Sets.union(this.nonObsoleteTermIds, this.obsoleteTermIds));
        this.relationMap = relationMap;
        this.precomputedAncestors = this.precomputeAncestors();
    }

    private ImmutableMap<TermId, ImmutableSet<TermId>> precomputeAncestors() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (TermId termId : this.graph.vertexSet()) {
            ImmutableSet.Builder setBuilder = ImmutableSet.builder();
            BreadthFirstSearch bfs = new BreadthFirstSearch();
            bfs.startFromForward((DefaultDirectedGraph)this.graph, termId, (g, v) -> {
                setBuilder.add((Object)v);
                return true;
            });
            mapBuilder.put((Object)termId, (Object)setBuilder.build());
        }
        return mapBuilder.build();
    }

    @Override
    public Map<String, String> getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public DefaultDirectedGraph<TermId, IdLabeledEdge> getGraph() {
        return this.graph;
    }

    @Override
    public Map<TermId, Term> getTermMap() {
        return this.termMap;
    }

    @Override
    public Map<Integer, Relationship> getRelationMap() {
        return this.relationMap;
    }

    @Override
    public boolean isRootTerm(TermId termId) {
        return termId.equals(this.rootTermId);
    }

    @Override
    public Set<TermId> getAncestorTermIds(TermId termId, boolean includeRoot) {
        TermId primaryTermId = this.getPrimaryTermId(termId);
        if (primaryTermId == null) {
            return ImmutableSet.of();
        }
        ImmutableSet precomputed = (ImmutableSet)this.precomputedAncestors.getOrDefault((Object)termId, (Object)ImmutableSet.of());
        if (includeRoot) {
            return precomputed;
        }
        return ImmutableSet.copyOf((Collection)Sets.difference((Set)precomputed, (Set)ImmutableSet.of((Object)this.rootTermId)));
    }

    @Override
    public Set<TermId> getAllAncestorTermIds(Collection<TermId> termIds, boolean includeRoot) {
        HashSet<TermId> result = new HashSet<TermId>();
        for (TermId termId : termIds) {
            result.addAll(this.getAncestorTermIds(termId, true));
        }
        if (!includeRoot) {
            result.remove(this.rootTermId);
        }
        return result;
    }

    @Override
    public TermId getRootTermId() {
        return this.rootTermId;
    }

    @Override
    public Set<TermId> getAllTermIds() {
        return this.allTermIds;
    }

    @Override
    public Collection<Term> getTerms() {
        return this.termMap.values();
    }

    @Override
    public Set<TermId> getNonObsoleteTermIds() {
        return this.nonObsoleteTermIds;
    }

    @Override
    public Set<TermId> getObsoleteTermIds() {
        return this.obsoleteTermIds;
    }

    @Override
    public Ontology subOntology(TermId subOntologyRoot) {
        Set<TermId> childTermIds = OntologyTerms.childrenOf(subOntologyRoot, this);
        DefaultDirectedGraph<TermId, IdLabeledEdge> subGraph = GraphUtil.subGraph(this.graph, childTermIds);
        Sets.SetView intersectingTerms = Sets.intersection(this.nonObsoleteTermIds, childTermIds);
        ImmutableMap.Builder termBuilder = ImmutableMap.builder();
        for (TermId tid : intersectingTerms) {
            termBuilder.put((Object)tid, this.termMap.get((Object)tid));
        }
        ImmutableMap subsetTermMap = termBuilder.build();
        ImmutableMap.Builder relationBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.relationMap.entrySet()) {
            Relationship tr = (Relationship)entry.getValue();
            if (!subsetTermMap.containsKey((Object)tr.getSource()) || !subsetTermMap.containsKey((Object)tr.getTarget())) continue;
            relationBuilder.put(entry.getKey(), entry.getValue());
        }
        ImmutableSortedMap.Builder metaInfoBuilder = ImmutableSortedMap.naturalOrder();
        for (Map.Entry entry : this.metaInfo.entrySet()) {
            metaInfoBuilder.put(entry.getKey(), entry.getValue());
        }
        metaInfoBuilder.put((Object)"provenance", (Object)String.format("Ontology created as a subset from original ontology with root %s", this.getTermMap().get(this.rootTermId).getName()));
        ImmutableSortedMap extendedMetaInfo = metaInfoBuilder.build();
        return new ImmutableOntology((ImmutableSortedMap<String, String>)extendedMetaInfo, subGraph, subOntologyRoot, (Collection<TermId>)intersectingTerms, (Collection<TermId>)Sets.intersection(this.obsoleteTermIds, childTermIds), (ImmutableMap<TermId, Term>)subsetTermMap, (ImmutableMap<Integer, Relationship>)relationBuilder.build());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, String> metaInfo = new LinkedHashMap<String, String>();
        private Collection<Term> terms = new ArrayList<Term>();
        private Collection<Relationship> relationships = new ArrayList<Relationship>();

        public Builder metaInfo(Map<String, String> metaInfo) {
            Objects.requireNonNull(metaInfo);
            this.metaInfo = new LinkedHashMap<String, String>(metaInfo);
            return this;
        }

        public Builder terms(Collection<Term> terms) {
            Objects.requireNonNull(terms);
            this.terms = new ArrayList<Term>(terms);
            return this;
        }

        public Builder relationships(Collection<Relationship> relationships) {
            Objects.requireNonNull(relationships);
            this.relationships = new ArrayList<Relationship>(relationships);
            return this;
        }

        public ImmutableOntology build() {
            TermId rootId = this.findRootTermId();
            HashSet nonObsoleteTermIds = Sets.newHashSet();
            TreeMap termsMap = Maps.newTreeMap();
            for (Term term : this.terms) {
                if (term.isObsolete()) continue;
                TermId termId = term.getId();
                nonObsoleteTermIds.add(termId);
                termsMap.put(termId, term);
                for (TermId alternateId : term.getAltTermIds()) {
                    termsMap.put(alternateId, term);
                }
            }
            Set<TermId> obsoleteTermIds = this.terms.stream().filter(Term::isObsolete).map(Term::getId).collect(Collectors.toSet());
            Map relationshipMap = this.relationships.stream().collect(Collectors.toMap(Relationship::getId, Function.identity()));
            DefaultDirectedGraph<TermId, IdLabeledEdge> phenolGraph = this.makeDefaultDirectedGraph(nonObsoleteTermIds, this.relationships);
            return new ImmutableOntology((ImmutableSortedMap<String, String>)ImmutableSortedMap.copyOf(this.metaInfo), phenolGraph, rootId, nonObsoleteTermIds, obsoleteTermIds, (ImmutableMap<TermId, Term>)ImmutableMap.copyOf((Map)termsMap), (ImmutableMap<Integer, Relationship>)ImmutableMap.copyOf(relationshipMap));
        }

        private DefaultDirectedGraph<TermId, IdLabeledEdge> makeDefaultDirectedGraph(Set<TermId> nonObsoleteTermIds, Collection<Relationship> relationships) {
            DefaultDirectedGraph phenolGraph = new DefaultDirectedGraph(IdLabeledEdge.class);
            nonObsoleteTermIds.forEach(arg_0 -> ((DefaultDirectedGraph)phenolGraph).addVertex(arg_0));
            for (Relationship relationship : relationships) {
                TermId subjectTermId = relationship.getSource();
                TermId objectTermId = relationship.getTarget();
                phenolGraph.addVertex((Object)subjectTermId);
                phenolGraph.addVertex((Object)objectTermId);
                phenolGraph.addEdge((Object)subjectTermId, (Object)objectTermId, (Object)new IdLabeledEdge(relationship.getId()));
            }
            CompatibilityChecker.check(phenolGraph.vertexSet(), phenolGraph.edgeSet());
            return phenolGraph;
        }

        private TermId findRootTermId() {
            List<TermId> rootCandidates = this.findRootCandidates(this.relationships);
            logger.debug("Root candidates: {}", rootCandidates);
            if (rootCandidates.isEmpty()) {
                throw new PhenolRuntimeException("No root candidate found.");
            }
            if (rootCandidates.size() == 1) {
                return rootCandidates.get(0);
            }
            Term artificialRootTerm = Term.of(TermId.of("owl", "Thing"), "artificial root term");
            logger.debug("Created new artificial root term {} {}", (Object)artificialRootTerm.getId(), (Object)artificialRootTerm.getName());
            this.addArtificialRootTerm(artificialRootTerm, rootCandidates);
            return artificialRootTerm.getId();
        }

        private List<TermId> findRootCandidates(Collection<Relationship> relationships) {
            HashSet rootCandidateSet = Sets.newHashSet();
            HashSet removeMarkSet = Sets.newHashSet();
            for (Relationship relationship : relationships) {
                TermId subjectTermId = relationship.getSource();
                TermId objectTermId = relationship.getTarget();
                rootCandidateSet.add(objectTermId);
                removeMarkSet.add(subjectTermId);
            }
            rootCandidateSet.removeAll(removeMarkSet);
            return new ArrayList<TermId>(rootCandidateSet);
        }

        private void addArtificialRootTerm(Term rootTerm, List<TermId> rootCandidates) {
            this.terms.add(rootTerm);
            int edgeId = 1 + this.relationships.stream().mapToInt(Relationship::getId).max().orElse(0);
            for (TermId rootCandidate : rootCandidates) {
                IdLabeledEdge idLabeledEdge = new IdLabeledEdge(edgeId++);
                Relationship relationship = new Relationship(rootCandidate, rootTerm.getId(), idLabeledEdge.getId(), RelationshipType.IS_A);
                logger.debug("Adding new artificial root relationship {}", (Object)relationship);
                this.relationships.add(relationship);
            }
        }
    }
}

