/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import java.util.Objects;
import org.monarchinitiative.phenol.ontology.data.RelationshipType;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class Relationship {
    private static final long serialVersionUID = 2L;
    protected final TermId source;
    protected final TermId target;
    protected final int id;
    private final RelationshipType relationshipType;

    public Relationship(TermId source, TermId target, int id, RelationshipType relationshipType) {
        this.source = source;
        this.target = target;
        this.id = id;
        this.relationshipType = relationshipType;
    }

    public TermId getSource() {
        return this.source;
    }

    public TermId getTarget() {
        return this.target;
    }

    public int getId() {
        return this.id;
    }

    public RelationshipType getRelationshipType() {
        return this.relationshipType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Relationship that = (Relationship)o;
        return this.id == that.id && Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && this.relationshipType == that.relationshipType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.target, this.id, this.relationshipType});
    }

    public String toString() {
        return "Relationship [source=" + this.source + ", target=" + this.target + ", id=" + this.id + ", relationshipType=" + (Object)((Object)this.relationshipType) + "]";
    }
}

