/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RelationshipType {
    IS_A("is_a"),
    INTERSECTION_OF("intersection_of"),
    UNION_OF("union_of"),
    DISJOINT_FROM("disjoint_from"),
    PART_OF("part_of"),
    HAS_PART("has_part"),
    REGULATES("regulates"),
    NEGATIVELY_REGULATES("negatively_regulates"),
    POSITIVELY_REGULATES("positively_regulates"),
    OCCURS_IN("occurs_in"),
    HAPPENS_DURING("happens_during"),
    ENDS_DURING("ends_during"),
    SUBPROPERTY_OF("subpropertyOf"),
    INVERSE_OF("inverseOf"),
    HAS_MODIFIER("hasModifier"),
    DISEASE_HAS_BASIS_IN_FEATURE("disease_has_basis_in_feature"),
    DISEASE_SHARES_FEATURES_OF("disease_shares_features_of"),
    DISEASE_HAS_FEATURE("disease_has_feature"),
    DISEASE_HAS_MAJOR_FEATURE("disease_has_major_feature"),
    DISEASE_CAUSES_FEATURE("disease_causes_feature"),
    DISEASE_HAS_LOCATION("disease_has_location"),
    PART_OF_PROGRESSION_OF_DISEASE("part_of_progression_of_disease"),
    REALIZED_IN_RESPONSE_TO_STIMULUS("realized_in_response_to_stimulus"),
    UNKNOWN("unknown");

    private static final Logger logger;
    private final String relationshipName;

    private RelationshipType(String name) {
        this.relationshipName = name;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    public static RelationshipType fromString(String reltype) {
        switch (reltype) {
            case "is_a": {
                return IS_A;
            }
            case "http://purl.obolibrary.org/obo/BFO_0000050": 
            case "part of": 
            case "part_of": {
                return PART_OF;
            }
            case "http://purl.obolibrary.org/obo/BFO_0000051": 
            case "has part": {
                return HAS_PART;
            }
            case "http://purl.obolibrary.org/obo/RO_0002211": 
            case "regulates": {
                return REGULATES;
            }
            case "http://purl.obolibrary.org/obo/RO_0002212": 
            case "negatively regulates": {
                return NEGATIVELY_REGULATES;
            }
            case "http://purl.obolibrary.org/obo/RO_0002213": 
            case "positively regulates": {
                return POSITIVELY_REGULATES;
            }
            case "http://purl.obolibrary.org/obo/BFO_0000066": 
            case "occurs in": {
                return OCCURS_IN;
            }
            case "http://purl.obolibrary.org/obo/RO_0002092": 
            case "happens during": {
                return HAPPENS_DURING;
            }
            case "http://purl.obolibrary.org/obo/RO_0002093": 
            case "ends during": {
                return ENDS_DURING;
            }
            case "subPropertyOf": {
                return SUBPROPERTY_OF;
            }
            case "inverseOf": {
                return INVERSE_OF;
            }
            case "http://purl.obolibrary.org/obo/RO_0002573": 
            case "has modifier": {
                return HAS_MODIFIER;
            }
            case "http://purl.obolibrary.org/obo/RO_0004022": {
                return DISEASE_HAS_BASIS_IN_FEATURE;
            }
            case "http://purl.obolibrary.org/obo/mondo#disease_shares_features_of": {
                return DISEASE_SHARES_FEATURES_OF;
            }
            case "http://purl.obolibrary.org/obo/RO_0004029": {
                return DISEASE_HAS_FEATURE;
            }
            case "http://purl.obolibrary.org/obo/mondo#disease_has_major_feature": {
                return DISEASE_HAS_MAJOR_FEATURE;
            }
            case "http://purl.obolibrary.org/obo/RO_0004026": {
                return DISEASE_HAS_LOCATION;
            }
            case "http://purl.obolibrary.org/obo/mondo#disease_causes_feature": {
                return DISEASE_CAUSES_FEATURE;
            }
            case "http://purl.obolibrary.org/obo/mondo#part_of_progression_of_disease": {
                return PART_OF_PROGRESSION_OF_DISEASE;
            }
            case "http://purl.obolibrary.org/obo/RO_0004028": {
                return REALIZED_IN_RESPONSE_TO_STIMULUS;
            }
        }
        logger.warn("Unknown relationship: {}", (Object)reltype);
        return UNKNOWN;
    }

    public boolean propagates() {
        switch (this) {
            case IS_A: 
            case PART_OF: {
                return true;
            }
        }
        return false;
    }

    static {
        logger = LoggerFactory.getLogger(RelationshipType.class);
    }
}

