/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.data;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.monarchinitiative.phenol.ontology.data.Dbxref;
import org.monarchinitiative.phenol.ontology.data.SimpleXref;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.data.TermSynonym;

public class Term {
    private static final long serialVersionUID = 2L;
    private final TermId id;
    private final List<TermId> altTermIds;
    private final String name;
    private final String definition;
    private final List<SimpleXref> databaseXrefs;
    private final String comment;
    private final List<String> subsets;
    private final List<TermSynonym> synonyms;
    private final boolean obsolete;
    private final String createdBy;
    private final Date creationDate;
    private final List<Dbxref> xrefs;

    public static Term of(String termIdString, String name) {
        Objects.requireNonNull(termIdString);
        Objects.requireNonNull(name);
        TermId termId = TermId.of(termIdString);
        return new Term(termId, name);
    }

    public static Term of(TermId termId, String name) {
        Objects.requireNonNull(termId);
        Objects.requireNonNull(name);
        return new Term(termId, name);
    }

    private Term(TermId termId, String name) {
        this.id = termId;
        this.name = name;
        this.altTermIds = ImmutableList.of();
        this.definition = "";
        this.databaseXrefs = ImmutableList.of();
        this.comment = "";
        this.subsets = ImmutableList.of();
        this.synonyms = ImmutableList.of();
        this.obsolete = false;
        this.createdBy = "";
        this.creationDate = null;
        this.xrefs = ImmutableList.of();
    }

    private Term(Builder builder) {
        Objects.requireNonNull(builder.id);
        this.id = builder.id;
        Objects.requireNonNull(builder.name);
        this.name = builder.name;
        this.altTermIds = ImmutableList.copyOf((Collection)builder.altTermIds);
        Objects.requireNonNull(builder.definition);
        this.definition = builder.definition;
        this.databaseXrefs = ImmutableList.copyOf((Collection)builder.databaseXrefs);
        Objects.requireNonNull(builder.comment);
        this.comment = builder.comment;
        this.subsets = ImmutableList.copyOf((Collection)builder.subsets);
        this.synonyms = ImmutableList.copyOf((Collection)builder.synonyms);
        this.obsolete = builder.obsolete;
        Objects.requireNonNull(builder.createdBy);
        this.createdBy = builder.createdBy;
        this.creationDate = builder.creationDate;
        this.xrefs = ImmutableList.copyOf((Collection)builder.xrefs);
    }

    public TermId getId() {
        return this.id;
    }

    public List<TermId> getAltTermIds() {
        return this.altTermIds;
    }

    public String getName() {
        return this.name;
    }

    public String getDefinition() {
        return this.definition;
    }

    public List<SimpleXref> getDatabaseXrefs() {
        return this.databaseXrefs;
    }

    public List<SimpleXref> getPmidXrefs() {
        return this.databaseXrefs.stream().filter(SimpleXref::isPmid).collect(Collectors.toList());
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getSubsets() {
        return this.subsets;
    }

    public List<TermSynonym> getSynonyms() {
        return this.synonyms;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Optional<Date> getCreationDate() {
        return Optional.ofNullable(this.creationDate);
    }

    public List<Dbxref> getXrefs() {
        return this.xrefs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Term term = (Term)o;
        return this.obsolete == term.obsolete && Objects.equals(this.id, term.id) && Objects.equals(this.altTermIds, term.altTermIds) && Objects.equals(this.name, term.name) && Objects.equals(this.definition, term.definition) && Objects.equals(this.databaseXrefs, term.databaseXrefs) && Objects.equals(this.comment, term.comment) && Objects.equals(this.subsets, term.subsets) && Objects.equals(this.synonyms, term.synonyms) && Objects.equals(this.createdBy, term.createdBy) && Objects.equals(this.creationDate, term.creationDate) && Objects.equals(this.xrefs, term.xrefs);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.altTermIds, this.name, this.definition, this.databaseXrefs, this.comment, this.subsets, this.synonyms, this.obsolete, this.createdBy, this.creationDate, this.xrefs);
    }

    public String toString() {
        return "Term [id=" + this.id + ", altTermIds=" + this.altTermIds + ", name=" + this.name + ", definition=" + this.definition + ", comment=" + this.comment + ", subsets=" + this.subsets + ", synonyms=" + this.synonyms + ", obsolete=" + this.obsolete + ", createdBy=" + this.createdBy + ", creationDate=" + this.creationDate + ", xrefs=" + this.xrefs + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TermId id = null;
        private String name = null;
        private List<TermId> altTermIds = ImmutableList.of();
        private String definition = "";
        private List<SimpleXref> databaseXrefs = ImmutableList.of();
        private String comment = "";
        private List<String> subsets = ImmutableList.of();
        private List<TermSynonym> synonyms = ImmutableList.of();
        private boolean obsolete = false;
        private String createdBy = "";
        private Date creationDate;
        private List<Dbxref> xrefs = ImmutableList.of();

        public Builder id(TermId id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder altTermIds(List<TermId> altTermIds) {
            this.altTermIds = altTermIds;
            return this;
        }

        public Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public Builder databaseXrefs(List<SimpleXref> databaseXrefs) {
            this.databaseXrefs = databaseXrefs;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder subsets(List<String> subsets) {
            this.subsets = subsets;
            return this;
        }

        public Builder synonyms(List<TermSynonym> synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public Builder obsolete(boolean obsolete) {
            this.obsolete = obsolete;
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder creationDate(Date creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Builder xrefs(List<Dbxref> xrefs) {
            this.xrefs = xrefs;
            return this;
        }

        public Term build() {
            return new Term(this);
        }
    }
}

