/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.scoredist;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class ObjectScoreDistribution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int objectId;
    private final int numTerms;
    private final int sampleSize;
    private final SortedMap<Double, Double> cumulativeFrequencies;

    public ObjectScoreDistribution(int objectId, int numTerms, int sampleSize, SortedMap<Double, Double> cumulativeFrequencies) {
        this.objectId = objectId;
        this.numTerms = numTerms;
        this.sampleSize = sampleSize;
        this.cumulativeFrequencies = cumulativeFrequencies;
    }

    public double estimatePValue(double score) {
        Map.Entry<Double, Double> previous = null;
        for (Map.Entry<Double, Double> entry : this.cumulativeFrequencies.entrySet()) {
            if (previous == null && score < entry.getKey()) {
                return 1.0;
            }
            if (previous != null && (Double)previous.getKey() <= score && score < entry.getKey()) {
                double dx = (entry.getKey() - previous.getKey()) / 2.0;
                return 1.0 - (previous.getValue() + dx * (entry.getValue() - previous.getValue()));
            }
            previous = entry;
        }
        return 0.0;
    }

    public List<Double> observedScores() {
        return new ArrayList<Double>(this.cumulativeFrequencies.keySet());
    }

    public SortedMap<Double, Double> getCumulativeFrequencies() {
        return new TreeMap<Double, Double>(this.cumulativeFrequencies);
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getNumTerms() {
        return this.numTerms;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public String toString() {
        return "ObjectScoreDistribution [objectId=" + this.objectId + ", numTerms=" + this.numTerms + ", sampleSize=" + this.sampleSize + ", cumulativeFrequencies=" + this.cumulativeFrequencies + "]";
    }
}

