/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ontology.similarity;

import java.io.Serializable;
import java.util.Collection;
import org.monarchinitiative.phenol.ontology.data.TermId;
import org.monarchinitiative.phenol.ontology.similarity.PairwiseSimilarity;
import org.monarchinitiative.phenol.ontology.similarity.Similarity;

abstract class AbstractCommonAncestorSimilarity
implements Similarity,
Serializable {
    static final long serialVersionUID = 2L;
    private final boolean symmetric;
    private final PairwiseSimilarity pairwiseSimilarity;

    public AbstractCommonAncestorSimilarity(PairwiseSimilarity pairwiseSimilarity, boolean symmetric) {
        this.symmetric = symmetric;
        this.pairwiseSimilarity = pairwiseSimilarity;
    }

    @Override
    public final double computeScore(Collection<TermId> query, Collection<TermId> target) {
        if (this.symmetric) {
            return 0.5 * (this.computeScoreImpl(query, target) + this.computeScoreImpl(target, query));
        }
        return this.computeScoreImpl(query, target);
    }

    protected final double computeScoreImpl(Collection<TermId> query, Collection<TermId> target) {
        double sum = 0.0;
        for (TermId q : query) {
            double maxValue = 0.0;
            for (TermId t : target) {
                maxValue = Math.max(maxValue, this.pairwiseSimilarity.computeScore(q, t));
            }
            sum += maxValue;
        }
        return sum / (double)query.size();
    }

    @Override
    public final boolean isSymmetric() {
        return this.symmetric;
    }

    @Override
    public String getParameters() {
        return "{symmetric: " + this.isSymmetric() + "}";
    }
}

