/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.ser;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.monarchinitiative.phenol.ser.SerializationException;
import org.monarchinitiative.phenol.ser.SerializationRuntimeException;
import org.monarchinitiative.phenol.ser.VersionComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSerializer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String filename;
    private final byte[] magicBytes;
    private final String minVersion;

    public static String getVersion() {
        Properties properties = new Properties();
        try {
            properties.load(DataSerializer.class.getResourceAsStream("/project.properties"));
        }
        catch (IOException e) {
            throw new SerializationRuntimeException("Could not load project.properties for obtaining version", e);
        }
        return properties.getProperty("version");
    }

    public DataSerializer(byte[] magicBytes, String minVersion, String filename) {
        this.magicBytes = magicBytes;
        this.minVersion = minVersion;
        this.filename = filename;
    }

    public void save(Object data) throws SerializationException {
        this.LOGGER.info("Attempting serialization to {}", new Object[]{this.filename});
        long startTime = System.nanoTime();
        try (FileOutputStream fos = new FileOutputStream(this.filename);){
            fos.write(this.magicBytes);
            fos.flush();
            try (GZIPOutputStream gzos = new GZIPOutputStream(fos);
                 ObjectOutputStream oos = new ObjectOutputStream(gzos);){
                String version = DataSerializer.getVersion();
                oos.writeObject(version);
                oos.writeObject(data);
                oos.flush();
                gzos.flush();
                fos.flush();
            }
        }
        catch (Exception e) {
            throw new SerializationException("Could not serialize data file.", e);
        }
        this.LOGGER.info("Serialization took {} sec.", new Object[]{(double)(System.nanoTime() - startTime) / 1.0E9});
    }

    public Object load() throws SerializationException {
        Object result;
        this.LOGGER.info("Attempting deserialization from {}", new Object[]{this.filename});
        long startTime = System.nanoTime();
        try (FileInputStream fileIn = new FileInputStream(this.filename);){
            byte[] word = new byte[this.magicBytes.length];
            fileIn.read(word);
            if (!Arrays.equals(word, this.magicBytes)) {
                throw new SerializationException(this.filename + " does not look like a data file, magic number incorrect!");
            }
            try (GZIPInputStream gzIn = new GZIPInputStream(fileIn);
                 ObjectInputStream in = new ObjectInputStream(gzIn);){
                String dbVersion = (String)in.readObject();
                VersionComparator comp = new VersionComparator();
                if (comp.compare(dbVersion, this.minVersion) < 0) {
                    throw new SerializationException(this.filename + " was created by " + dbVersion + " but we need at least " + this.minVersion);
                }
                result = in.readObject();
            }
        }
        catch (Exception e) {
            throw new SerializationException("Could not deserialize data from file", e);
        }
        this.LOGGER.info("Done with deserialization, took {} sec.", new Object[]{(double)(System.nanoTime() - startTime) / 1.0E9});
        return result;
    }
}

