/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Set;
import org.geneontology.obographs.model.GraphDocument;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.io.obo.OboGraphDocumentAdaptor;
import org.monarchinitiative.phenol.io.obo.OboGraphDocumentLoader;
import org.monarchinitiative.phenol.io.utils.CurieUtilBuilder;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.prefixcommons.CurieUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyLoader {
    private static final Logger logger = LoggerFactory.getLogger(OntologyLoader.class);

    private OntologyLoader() {
    }

    public static Ontology loadOntology(File file) {
        return OntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static Ontology loadOntology(File file, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(file, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static Ontology loadOntology(File file, CurieUtil curieUtil, String ... termIdPrefixes) {
        try {
            return OntologyLoader.loadOntology((InputStream)new FileInputStream(file), curieUtil, termIdPrefixes);
        }
        catch (FileNotFoundException e) {
            throw new PhenolRuntimeException("Unable to load ontology", (Throwable)e);
        }
    }

    public static Ontology loadOntology(InputStream inputStream) {
        return OntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), new String[0]);
    }

    public static Ontology loadOntology(InputStream inputStream, String ... termIdPrefixes) {
        return OntologyLoader.loadOntology(inputStream, CurieUtilBuilder.defaultCurieUtil(), termIdPrefixes);
    }

    public static Ontology loadOntology(InputStream inputStream, CurieUtil curieUtil, String ... termIdPrefixes) {
        GraphDocument graphDocument = OntologyLoader.loadGraphDocument(inputStream);
        logger.debug("Finished loading ontology");
        logger.debug("Creating phenol ontology");
        OboGraphDocumentAdaptor graphDocumentAdaptor = OboGraphDocumentAdaptor.builder().curieUtil(curieUtil).wantedTermIdPrefixes((Set<String>)ImmutableSet.copyOf((Object[])termIdPrefixes)).build(graphDocument);
        Ontology ontology = graphDocumentAdaptor.buildOntology();
        logger.debug("Parsed a total of {} terms", (Object)ontology.countAllTerms());
        return ontology;
    }

    private static GraphDocument loadGraphDocument(InputStream inputStream) {
        try {
            return OboGraphDocumentLoader.loadObo(inputStream);
        }
        catch (Exception e) {
            logger.debug("Error loading OBO", (Throwable)e);
            try {
                return OboGraphDocumentLoader.loadJson(inputStream);
            }
            catch (Exception e2) {
                throw new PhenolRuntimeException("Unable to load ontology", (Throwable)e2);
            }
        }
    }
}

