/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.annotations.hpo;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModel;
import org.monarchinitiative.phenol.base.HpoAnnotationModelException;
import org.monarchinitiative.phenol.base.PhenolRuntimeException;
import org.monarchinitiative.phenol.formats.hpo.HpoFrequencyTermIds;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class OrphanetXML2HpoDiseaseModelParser {
    private final String orphanetXmlPath;
    private final Ontology ontology;
    private final String orphanetBiocurationString;
    private final List<HpoAnnotationModel> orphanetDiseaseList = new ArrayList<HpoAnnotationModel>();
    private boolean replaceObsoleteTermId;

    public OrphanetXML2HpoDiseaseModelParser(String xmlpath, Ontology onto, boolean tolerant) {
        this.orphanetXmlPath = xmlpath;
        this.ontology = onto;
        this.replaceObsoleteTermId = tolerant;
        String todaysDate = this.getTodaysDate();
        this.orphanetBiocurationString = String.format("ORPHA:orphadata[%s]", todaysDate);
        try {
            this.parse();
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public List<HpoAnnotationModel> getOrphanetDiseaseModels() {
        return this.orphanetDiseaseList;
    }

    private TermId string2frequency(String fstring) throws PhenolRuntimeException {
        switch (fstring) {
            case "28405": {
                return HpoFrequencyTermIds.ALWAYS_PRESENT;
            }
            case "28412": {
                return HpoFrequencyTermIds.VERY_FREQUENT;
            }
            case "28419": {
                return HpoFrequencyTermIds.FREQUENT;
            }
            case "28426": {
                return HpoFrequencyTermIds.OCCASIONAL;
            }
            case "28433": {
                return HpoFrequencyTermIds.VERY_RARE;
            }
            case "28440": {
                return HpoFrequencyTermIds.EXCLUDED;
            }
        }
        throw new PhenolRuntimeException("[ERROR] Could not find TermId for Orphanet frequency {}. This indicates a serious and unexpected error, please report to the developers" + fstring);
    }

    private void parse() throws XMLStreamException, IOException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(new FileInputStream(this.orphanetXmlPath));
        boolean inFrequency = false;
        boolean inDiagnosticCriterion = false;
        String currentHpoId = null;
        String currentHpoTermLabel = null;
        TermId currentFrequencyTermId = null;
        String currentOrphanumber = null;
        String currentDiseaseName = null;
        ArrayList<HpoAnnotationEntry> currentAnnotationEntryList = new ArrayList<HpoAnnotationEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                StartElement startElement = xmlEvent.asStartElement();
                switch (startElement.getName().getLocalPart()) {
                    case "Disorder": {
                        break;
                    }
                    case "OrphaNumber": {
                        if (inFrequency || inDiagnosticCriterion) break;
                        xmlEvent = xmlEventReader.nextEvent();
                        currentOrphanumber = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "Name": {
                        if (inFrequency || inDiagnosticCriterion) break;
                        xmlEvent = xmlEventReader.nextEvent();
                        currentDiseaseName = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "HPOId": {
                        xmlEvent = xmlEventReader.nextEvent();
                        currentHpoId = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "HPOTerm": {
                        xmlEvent = xmlEventReader.nextEvent();
                        currentHpoTermLabel = xmlEvent.asCharacters().getData();
                        break;
                    }
                    case "HPOFrequency": {
                        Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                        if (idAttr != null) {
                            currentFrequencyTermId = this.string2frequency(idAttr.getValue());
                        }
                        inFrequency = true;
                        break;
                    }
                    case "DiagnosticCriteria": {
                        inDiagnosticCriterion = true;
                        break;
                    }
                    case "HPO": {
                        break;
                    }
                    case "JDBOR": {
                        break;
                    }
                }
                continue;
            }
            if (!xmlEvent.isEndElement()) continue;
            EndElement endElement = xmlEvent.asEndElement();
            String endElementName = endElement.getName().getLocalPart();
            if (endElementName.equals("HPOFrequency")) {
                inFrequency = false;
                continue;
            }
            if (endElementName.equals("DiagnosticCriteria")) {
                inDiagnosticCriterion = false;
                continue;
            }
            if (endElementName.equals("HPODisorderAssociation")) {
                try {
                    HpoAnnotationEntry entry = HpoAnnotationEntry.fromOrphaData((String)String.format("ORPHA:%s", currentOrphanumber), (String)currentDiseaseName, (String)currentHpoId, (String)currentHpoTermLabel, (TermId)currentFrequencyTermId, (Ontology)this.ontology, (String)this.orphanetBiocurationString, (boolean)this.replaceObsoleteTermId);
                    currentHpoId = null;
                    currentHpoTermLabel = null;
                    currentFrequencyTermId = null;
                    currentAnnotationEntryList.add(entry);
                }
                catch (HpoAnnotationModelException e) {
                    System.err.println(String.format("Parse error for %s [ORPHA:%s] HPOid: %s (%s)", currentDiseaseName != null ? currentDiseaseName : "n/a", currentOrphanumber != null ? currentOrphanumber : "n/a", currentHpoId != null ? currentHpoId : "n/a", e.getMessage()));
                }
                continue;
            }
            if (endElementName.equals("Disorder")) {
                HpoAnnotationModel file = new HpoAnnotationModel(String.format("ORPHA:%s", currentOrphanumber), currentAnnotationEntryList);
                this.orphanetDiseaseList.add(file);
                currentOrphanumber = null;
                currentDiseaseName = null;
                currentAnnotationEntryList.clear();
                continue;
            }
            if (!endElementName.equals("JDBOR")) continue;
        }
    }

    private String getTodaysDate() {
        Date date = new Date();
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }
}

