/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.annotations.hpo;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationEntry;
import org.monarchinitiative.phenol.annotations.hpo.HpoAnnotationModel;
import org.monarchinitiative.phenol.base.HpoAnnotationModelException;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class PhenotypeDotHpoaFileWriter {
    private final List<HpoAnnotationModel> internalAnnotFileList;
    private final List<HpoAnnotationModel> orphanetSmallFileList;
    private final String outputFileName;
    private static final String EMPTY_STRING = "";
    private static final TermId phenotypeRoot = TermId.of((String)"HP:0000118");
    private static final TermId INHERITANCE_TERM_ID = TermId.of((String)"HP:0000005");
    private static final TermId CLINICAL_COURSE_ID = TermId.of((String)"HP:0031797");
    private static final TermId CLINICAL_MODIFIER_ID = TermId.of((String)"HP:0012823");
    private final Ontology ontology;
    private int n_orphanet;
    private int n_decipher;
    private int n_omim;
    private int n_unknown;
    private Map<String, String> ontologyMetaInfo;

    public PhenotypeDotHpoaFileWriter(Ontology ont, List<HpoAnnotationModel> internalAnnotFileList, List<HpoAnnotationModel> orphaList, String outpath) {
        this.ontology = ont;
        this.internalAnnotFileList = internalAnnotFileList;
        this.orphanetSmallFileList = orphaList;
        this.outputFileName = outpath;
    }

    public void setNumberOfDiseasesForHeader(int n_orpha) {
        this.n_orphanet = n_orpha;
        this.n_decipher = 0;
        this.n_omim = 0;
        this.n_unknown = 0;
        for (HpoAnnotationModel diseaseModel : this.internalAnnotFileList) {
            if (diseaseModel.isOMIM()) {
                ++this.n_omim;
                continue;
            }
            if (diseaseModel.isDECIPHER()) {
                ++this.n_decipher;
                continue;
            }
            ++this.n_unknown;
        }
        this.n_orphanet = this.orphanetSmallFileList.size();
    }

    public void setOntologyMetadata(Map<String, String> meta) {
        this.ontologyMetaInfo = meta;
    }

    private String getDate() {
        Date dNow = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        return ft.format(dNow);
    }

    public void outputBigFile() throws IOException {
        String description = String.format("#description: HPO annotations for rare diseases [%d: OMIM; %d: DECIPHER; %d ORPHANET]", this.n_omim, this.n_decipher, this.n_orphanet);
        if (this.n_unknown > 0) {
            description = String.format("%s -- warning: %d entries could not be assigned to a database", description, this.n_unknown);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFileName));
        writer.write(description + "\n");
        writer.write(String.format("#date: %s\n", this.getDate()));
        writer.write("#tracker: https://github.com/obophenotype/human-phenotype-ontology\n");
        if (this.ontologyMetaInfo.containsKey("data-version")) {
            writer.write(String.format("#HPO-version: %s\n", this.ontologyMetaInfo.get("data-version")));
        }
        if (this.ontologyMetaInfo.containsKey("saved-by")) {
            writer.write(String.format("#HPO-contributors: %s\n", this.ontologyMetaInfo.get("saved-by")));
        }
        int n = 0;
        writer.write(PhenotypeDotHpoaFileWriter.getHeaderLine() + "\n");
        for (HpoAnnotationModel smallFile : this.internalAnnotFileList) {
            List entryList = smallFile.getEntryList();
            for (HpoAnnotationEntry entry : entryList) {
                try {
                    String bigfileLine = this.transformEntry2BigFileLine(entry);
                    writer.write(bigfileLine + "\n");
                }
                catch (HpoAnnotationModelException e) {
                    System.err.println("Error encountered with entry " + entry.toString());
                    e.printStackTrace();
                }
                ++n;
            }
        }
        System.out.println("We output a total of " + n + " big file lines from internal HPO Annotation files");
        int m = 0;
        for (HpoAnnotationModel smallFile : this.orphanetSmallFileList) {
            List entryList = smallFile.getEntryList();
            for (HpoAnnotationEntry entry : entryList) {
                try {
                    String bigfileLine = this.transformEntry2BigFileLine(entry);
                    writer.write(bigfileLine + "\n");
                }
                catch (HpoAnnotationModelException e) {
                    System.err.println("Error encountered with entry " + entry.toString());
                    e.printStackTrace();
                }
                ++m;
            }
        }
        System.out.println("We output a total of " + m + " big file lines from internal HPO Annotation files");
        System.out.println("Total output lines was " + (n + m));
        writer.close();
    }

    String transformEntry2BigFileLine(HpoAnnotationEntry entry) throws HpoAnnotationModelException {
        CharSequence[] elems = new String[]{entry.getDiseaseID(), entry.getDiseaseName(), entry.getNegation(), entry.getPhenotypeId().getValue(), entry.getPublication(), entry.getEvidenceCode(), entry.getAgeOfOnsetId() != null ? entry.getAgeOfOnsetId() : EMPTY_STRING, entry.getFrequencyModifier() != null ? entry.getFrequencyModifier() : EMPTY_STRING, entry.getSex(), entry.getModifier(), this.getAspect(entry.getPhenotypeId()), entry.getBiocuration()};
        return String.join((CharSequence)"\t", elems);
    }

    private String getAspect(TermId tid) throws HpoAnnotationModelException {
        Term term = (Term)this.ontology.getTermMap().get(tid);
        if (term == null) {
            throw new HpoAnnotationModelException("Cannot compute Aspect of NULL term");
        }
        TermId primaryTid = term.getId();
        if (OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)primaryTid, (TermId)phenotypeRoot)) {
            return "P";
        }
        if (OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)primaryTid, (TermId)INHERITANCE_TERM_ID)) {
            return "I";
        }
        if (OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)primaryTid, (TermId)CLINICAL_COURSE_ID)) {
            return "C";
        }
        if (OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)primaryTid, (TermId)CLINICAL_MODIFIER_ID)) {
            return "M";
        }
        throw new HpoAnnotationModelException("Could not determine aspect of TermId " + tid.getValue());
    }

    static String getHeaderLine() {
        CharSequence[] fields = new String[]{"DatabaseID", "DiseaseName", "Qualifier", "HPO_ID", "Reference", "Evidence", "Onset", "Frequency", "Sex", "Modifier", "Aspect", "Biocuration"};
        return String.join((CharSequence)"\t", fields);
    }
}

