/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.assoc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.formats.Gene;
import org.monarchinitiative.phenol.formats.hpo.AssociationType;
import org.monarchinitiative.phenol.formats.hpo.DiseaseToGeneAssociation;
import org.monarchinitiative.phenol.formats.hpo.GeneToAssociation;
import org.monarchinitiative.phenol.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.formats.hpo.HpoGeneAnnotation;
import org.monarchinitiative.phenol.io.assoc.OrphaGeneToDiseaseParser;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.Term;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoAssociationParser {
    private final Ontology hpoOntology;
    private final String homoSapiensGeneInfoPath;
    private final String mim2geneMedgenPath;
    private final File orphaToGenePath;
    private BiMap<TermId, String> allGeneIdToSymbolMap;
    private ImmutableMap<TermId, String> geneIdToSymbolMap;
    private ImmutableMultimap<TermId, GeneToAssociation> associationMap;
    private ImmutableMultimap<TermId, TermId> diseaseToGeneMap;
    private ImmutableMultimap<TermId, TermId> geneToDiseaseMap;
    private ImmutableMap<TermId, DiseaseToGeneAssociation> diseaseToAssociationsMap;
    private Map<TermId, HpoDisease> termToDisease;
    private ImmutableList<HpoGeneAnnotation> phenotypeToGeneList;
    private List<DiseaseToGeneAssociation> associationList;
    private static final String ENTREZ_GENE_PREFIX = "NCBIGene";
    private static final String OMIM_PREFIX = "OMIM";

    public HpoAssociationParser(String geneInfoPath, String mim2geneMedgenPath, File orphaToGenePath, Ontology hpoOntology) {
        this.hpoOntology = hpoOntology;
        this.homoSapiensGeneInfoPath = geneInfoPath;
        this.mim2geneMedgenPath = mim2geneMedgenPath;
        this.orphaToGenePath = orphaToGenePath;
    }

    public HpoAssociationParser(File geneInfoPath, File mim2geneMedgenPath, File orphaToGenePath, Ontology hpoOntology) {
        this.hpoOntology = hpoOntology;
        this.homoSapiensGeneInfoPath = geneInfoPath.getAbsolutePath();
        this.mim2geneMedgenPath = mim2geneMedgenPath.getAbsolutePath();
        this.orphaToGenePath = orphaToGenePath;
    }

    public HpoAssociationParser(String geneInfoPath, String mim2geneMedgenPath, Ontology hpoOntology) {
        this.hpoOntology = hpoOntology;
        this.homoSapiensGeneInfoPath = geneInfoPath;
        this.mim2geneMedgenPath = mim2geneMedgenPath;
        this.orphaToGenePath = null;
    }

    public Map<TermId, DiseaseToGeneAssociation> getDiseaseToAssociationsMap() {
        return this.diseaseToAssociationsMap;
    }

    public Map<TermId, String> getGeneIdToSymbolMap() {
        return this.geneIdToSymbolMap;
    }

    public Multimap<TermId, TermId> getDiseaseToGeneIdMap() {
        return this.diseaseToGeneMap;
    }

    public Multimap<TermId, TermId> getGeneToDiseaseIdMap() {
        return this.geneToDiseaseMap;
    }

    public List<HpoGeneAnnotation> getPhenotypeToGene() {
        return this.phenotypeToGeneList;
    }

    public Map<TermId, HpoDisease> getTermToDisease() {
        return this.termToDisease;
    }

    public Multimap<TermId, GeneToAssociation> getDiseasetoGeneAssociation() {
        return this.associationMap;
    }

    public void setTermToGene(Multimap<TermId, TermId> phenotypeToDisease) throws PhenolException {
        if (this.diseaseToGeneMap.isEmpty()) {
            throw new PhenolException("Error: Associations not parsed. Please call parse then set the term to gene mapping.");
        }
        ImmutableList.Builder builderGeneAnnotationList = new ImmutableList.Builder();
        for (TermId phenotype : phenotypeToDisease.keySet()) {
            HashMap mappedGenes = new HashMap();
            phenotypeToDisease.get((Object)phenotype).stream().flatMap(disease -> this.diseaseToGeneMap.get(disease).stream()).collect(Collectors.toList()).forEach(gene -> {
                try {
                    Integer entrezId = Integer.parseInt(gene.getId());
                    if (!mappedGenes.containsKey(entrezId)) {
                        String entrezGeneSymbol = (String)this.geneIdToSymbolMap.get(gene);
                        if (entrezGeneSymbol == null) {
                            entrezGeneSymbol = "-";
                        }
                        String hpoTermName = ((Term)this.hpoOntology.getTermMap().get(phenotype)).getName();
                        HpoGeneAnnotation geneAnnotation = new HpoGeneAnnotation(entrezId.intValue(), entrezGeneSymbol, hpoTermName, phenotype);
                        builderGeneAnnotationList.add((Object)geneAnnotation);
                        mappedGenes.put(entrezId, true);
                    }
                }
                catch (Exception e) {
                    return;
                }
            });
        }
        this.phenotypeToGeneList = builderGeneAnnotationList.build();
    }

    public void setTermToDisease(Map<TermId, HpoDisease> termToDisease) {
        this.termToDisease = termToDisease;
    }

    private void setAssociationMaps() {
        ArrayListMultimap geneToDisease = ArrayListMultimap.create();
        ImmutableMap.Builder builderDiseasetoAssociation = new ImmutableMap.Builder();
        for (DiseaseToGeneAssociation g2p : this.associationList) {
            TermId diseaseId = g2p.getDiseaseId();
            List geneList = g2p.getGeneList();
            builderDiseasetoAssociation.put((Object)diseaseId, (Object)g2p);
            for (Gene g : geneList) {
                TermId geneId = g.getId();
                if (geneToDisease.containsEntry((Object)geneId, (Object)diseaseId)) continue;
                geneToDisease.put((Object)geneId, (Object)diseaseId);
            }
        }
        ImmutableMultimap.Builder builderGeneToDisease = new ImmutableMultimap.Builder();
        builderGeneToDisease.putAll((Multimap)geneToDisease);
        this.geneToDiseaseMap = builderGeneToDisease.build();
        this.diseaseToGeneMap = builderGeneToDisease.build().inverse();
        this.diseaseToAssociationsMap = builderDiseasetoAssociation.build();
    }

    public void parse() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        try {
            this.parseGeneInfo();
            this.parseDiseaseToGene();
            for (TermId omimCurie : this.associationMap.keySet()) {
                ImmutableCollection g2aList = this.associationMap.get((Object)omimCurie);
                DiseaseToGeneAssociation g2p = new DiseaseToGeneAssociation(omimCurie, (List)ImmutableList.copyOf((Collection)g2aList));
                builder.add((Object)g2p);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.associationList = builder.build();
        this.setAssociationMaps();
    }

    private void parseDiseaseToGene() throws IOException {
        ArrayListMultimap associationMap = ArrayListMultimap.create();
        HashMap<TermId, String> geneMap = new HashMap<TermId, String>();
        try (BufferedReader br = new BufferedReader(new FileReader(this.mim2geneMedgenPath));){
            String line;
            while ((line = br.readLine()) != null) {
                GeneToAssociation g2a;
                String[] associations;
                if (line.startsWith("#") || !(associations = line.split("\t"))[2].equals("phenotype")) continue;
                String mimid = associations[0];
                TermId omimCurie = TermId.of((String)OMIM_PREFIX, (String)mimid);
                String entrezGeneNumber = associations[1];
                TermId entrezId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                String symbol = (String)this.allGeneIdToSymbolMap.get((Object)entrezId);
                if ("-".equals(entrezGeneNumber)) continue;
                if (symbol == null) {
                    symbol = "-";
                } else if (!geneMap.containsKey(entrezId)) {
                    geneMap.put(entrezId, symbol);
                }
                TermId geneId = TermId.of((String)ENTREZ_GENE_PREFIX, (String)entrezGeneNumber);
                Gene gene = new Gene(geneId, symbol);
                if (associations[5].contains("susceptibility")) {
                    g2a = new GeneToAssociation(gene, AssociationType.POLYGENIC);
                    if (associationMap.containsEntry((Object)omimCurie, (Object)g2a)) continue;
                    associationMap.put((Object)omimCurie, (Object)g2a);
                    continue;
                }
                g2a = new GeneToAssociation(gene, AssociationType.MENDELIAN);
                if (associationMap.containsEntry((Object)omimCurie, (Object)g2a)) continue;
                associationMap.put((Object)omimCurie, (Object)g2a);
            }
        }
        if (this.orphaToGenePath != null) {
            BiMap geneSymbolToId = this.allGeneIdToSymbolMap.inverse();
            try {
                OrphaGeneToDiseaseParser parser = new OrphaGeneToDiseaseParser(this.orphaToGenePath);
                Multimap<TermId, String> orphaToGene = parser.getOrphaDiseaseToGeneSymbolMap();
                for (Map.Entry entry : orphaToGene.entries()) {
                    Gene gene;
                    GeneToAssociation g2a;
                    TermId orpha = (TermId)entry.getKey();
                    String geneSymbol = (String)entry.getValue();
                    if (!geneSymbolToId.containsKey(geneSymbol) || associationMap.containsEntry((Object)orpha, (Object)(g2a = new GeneToAssociation(gene = new Gene((TermId)geneSymbolToId.get(geneSymbol), geneSymbol), AssociationType.UNKNOWN)))) continue;
                    associationMap.put((Object)orpha, (Object)g2a);
                }
            }
            catch (PhenolException e) {
                System.err.println(e.toString());
            }
        }
        ImmutableMultimap.Builder associationBuilder = new ImmutableMultimap.Builder();
        associationBuilder.putAll((Multimap)associationMap);
        this.associationMap = associationBuilder.build();
        ImmutableMap.Builder geneBuilder = new ImmutableMap.Builder();
        geneBuilder.putAll(geneMap);
        this.geneIdToSymbolMap = geneBuilder.build();
        this.allGeneIdToSymbolMap = null;
    }

    private void parseGeneInfo() throws IOException {
        String line;
        ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
        FileInputStream fileStream = new FileInputStream(this.homoSapiensGeneInfoPath);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader(gzipStream);
        BufferedReader br = new BufferedReader(decoder);
        while ((line = br.readLine()) != null) {
            String[] a = line.split("\t");
            String taxon = a[0];
            if (!taxon.equals("9606") || "unknown".equals(a[9]) | "tRNA".equals(a[9]) | "rRNA".equals(a[9]) | "pseudo".equals(a[9])) continue;
            String geneId = a[1];
            String symbol = a[2];
            TermId tid = TermId.of((String)ENTREZ_GENE_PREFIX, (String)geneId);
            builder.put((Object)tid, (Object)symbol);
        }
        this.allGeneIdToSymbolMap = builder.build();
    }
}

