/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.assoc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.XMLEvent;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class OrphaGeneToDiseaseParser {
    private static final String DISORDER = "Disorder";
    private static final String ORPHA_NUMBER = "OrphaNumber";
    private static final String GENE_LIST = "GeneList";
    private static final String GENE = "Gene";
    private static final String NAME = "Name";
    private static final String DISORDER_GENE_ASSOCIATION_LIST = "DisorderGeneAssociationList";
    private static final String DISORDER_GENE_ASSOCIATION = "DisorderGeneAssociation";
    private static final String SYMBOL = "Symbol";
    private boolean inDisorder = false;
    private boolean inGeneList = false;
    private boolean inGene = true;
    private boolean inDisorderGeneAssociation = false;
    private boolean inDisorderGeneAssociationList = false;
    private final Multimap<TermId, String> orphaDiseaseToGeneSymbol = ArrayListMultimap.create();

    public OrphaGeneToDiseaseParser(File file) throws PhenolException {
        this.parse(file);
    }

    public Multimap<TermId, String> getOrphaDiseaseToGeneSymbolMap() {
        return this.orphaDiseaseToGeneSymbol;
    }

    private void parse(File file) throws PhenolException {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            FileInputStream in = new FileInputStream(file);
            XMLEventReader eventReader = inputFactory.createXMLEventReader(in);
            String currentOrphanum = null;
            String currentDiseasename = null;
            String currentGeneSymbol = null;
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (event.isStartElement()) {
                    String localPart = event.asStartElement().getName().getLocalPart();
                    if (this.inGeneList) continue;
                    if (localPart.equals(DISORDER)) {
                        this.inDisorder = true;
                        continue;
                    }
                    if (this.inDisorder && !this.inGeneList && !this.inDisorderGeneAssociationList && localPart.equals(ORPHA_NUMBER)) {
                        event = eventReader.nextEvent();
                        currentOrphanum = event.asCharacters().getData();
                        continue;
                    }
                    if (this.inDisorder && !this.inGeneList && !this.inDisorderGeneAssociationList && localPart.equals(NAME)) {
                        event = eventReader.nextEvent();
                        currentDiseasename = event.asCharacters().getData();
                        continue;
                    }
                    if (this.inDisorder && !this.inGeneList && !this.inDisorderGeneAssociationList && localPart.equals(GENE_LIST)) {
                        this.inGeneList = true;
                        continue;
                    }
                    if (localPart.equals(DISORDER_GENE_ASSOCIATION_LIST)) {
                        this.inDisorderGeneAssociationList = true;
                        continue;
                    }
                    if (this.inDisorderGeneAssociationList && localPart.equals(DISORDER_GENE_ASSOCIATION)) {
                        this.inDisorderGeneAssociation = true;
                        continue;
                    }
                    if (this.inDisorderGeneAssociation && localPart.equals(GENE)) {
                        this.inGene = true;
                        continue;
                    }
                    if (!this.inDisorder || !this.inDisorderGeneAssociation || !this.inDisorderGeneAssociationList || !this.inGene || !localPart.equals(SYMBOL)) continue;
                    event = eventReader.nextEvent();
                    currentGeneSymbol = event.asCharacters().getData();
                    continue;
                }
                if (!event.isEndElement()) continue;
                EndElement endElement = event.asEndElement();
                String localPart = endElement.getName().getLocalPart();
                if (localPart.equals(DISORDER)) {
                    this.inDisorder = false;
                    continue;
                }
                if (localPart.equals(GENE_LIST)) {
                    this.inGeneList = false;
                    continue;
                }
                if (localPart.equals(DISORDER_GENE_ASSOCIATION_LIST)) {
                    this.inDisorderGeneAssociationList = false;
                    currentOrphanum = null;
                    currentDiseasename = null;
                    continue;
                }
                if (localPart.equals(DISORDER_GENE_ASSOCIATION)) {
                    this.inDisorderGeneAssociation = false;
                    if (currentOrphanum == null || currentDiseasename == null || currentGeneSymbol == null) continue;
                    TermId orphaId = TermId.of((String)"ORPHA", (String)currentOrphanum);
                    this.orphaDiseaseToGeneSymbol.put((Object)orphaId, currentGeneSymbol);
                    currentGeneSymbol = null;
                    continue;
                }
                if (!endElement.getName().getLocalPart().equals(GENE)) continue;
                this.inGene = false;
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new PhenolException("Could not parse orpha disease to gene xml.");
        }
    }
}

