/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obo.go;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.formats.go.GoGaf21Annotation;
import org.monarchinitiative.phenol.io.base.TermAnnotationParserException;

public final class GoGeneAnnotationParser {
    private final File file;
    private final BufferedReader reader;
    private String nextLine;
    private final List<GoGaf21Annotation> annotations;

    public GoGeneAnnotationParser(File file) throws PhenolException {
        this.file = file;
        try {
            this.reader = new BufferedReader(new FileReader(file));
            this.nextLine = this.reader.readLine();
            this.skipHeaderAndCheckFirst();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            while (this.hasNext()) {
                GoGaf21Annotation annot = this.next();
                builder.add((Object)annot);
            }
            this.reader.close();
            this.annotations = builder.build();
        }
        catch (IOException | TermAnnotationParserException e) {
            String msg = String.format("Could not parse GO annotation file: %s", e.getMessage());
            throw new PhenolException(msg);
        }
    }

    public GoGeneAnnotationParser(String absolutepath) throws PhenolException {
        this(new File(absolutepath));
    }

    private void skipHeaderAndCheckFirst() throws TermAnnotationParserException, IOException {
        this.skipUntilData();
        if (this.nextLine == null) {
            throw new TermAnnotationParserException("GAF2.1 file contained no data!");
        }
        String[] arr = this.nextLine.split("\t");
        if (arr.length < 15 || arr.length > 17) {
            throw new TermAnnotationParserException("First line of file had " + arr.length + " columns, but expected between 15 and 17 entries.");
        }
    }

    private void skipUntilData() throws IOException {
        while (this.nextLine == null || this.nextLine.startsWith("!")) {
            this.nextLine = this.reader.readLine();
        }
    }

    public List<GoGaf21Annotation> getAnnotations() {
        return this.annotations;
    }

    private boolean hasNext() {
        return this.nextLine != null;
    }

    private GoGaf21Annotation next() throws IOException, PhenolException {
        this.skipUntilData();
        String[] arr = this.nextLine.split("\t");
        GoGaf21Annotation annot = new GoGaf21Annotation(arr);
        this.nextLine = this.reader.readLine();
        return annot;
    }

    public File getFile() {
        return this.file;
    }
}

