/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obo.hpo;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.formats.hpo.HpoAnnotation;
import org.monarchinitiative.phenol.formats.hpo.HpoDisease;
import org.monarchinitiative.phenol.formats.hpo.HpoModeOfInheritanceTermIds;
import org.monarchinitiative.phenol.io.obo.hpo.HpoAnnotationLine;
import org.monarchinitiative.phenol.ontology.algo.OntologyAlgorithm;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class HpoDiseaseAnnotationParser {
    private final String annotationFilePath;
    private final Ontology ontology;
    private final Map<TermId, HpoDisease> diseaseMap;
    private ImmutableMultimap<TermId, TermId> phenotypeToDiseaseMap;
    private List<String> errors;
    private final Set<String> DEFAULT_DATABASE_PREFIXES = ImmutableSet.of((Object)"OMIM", (Object)"ORPHA", (Object)"DECIPHER");
    private final Set<String> databasePrefixes;

    public HpoDiseaseAnnotationParser(String annotationFile, Ontology ontology) {
        this.annotationFilePath = annotationFile;
        this.ontology = ontology;
        this.diseaseMap = new HashMap<TermId, HpoDisease>();
        this.databasePrefixes = this.DEFAULT_DATABASE_PREFIXES;
    }

    public HpoDiseaseAnnotationParser(String annotationFile, Ontology ontology, List<String> databases) {
        this.annotationFilePath = annotationFile;
        this.ontology = ontology;
        this.diseaseMap = new HashMap<TermId, HpoDisease>();
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (String database : databases) {
            builder.add((Object)database);
        }
        this.databasePrefixes = builder.build();
    }

    public HpoDiseaseAnnotationParser(File annotationFile, Ontology ontology) {
        this.annotationFilePath = annotationFile.getAbsolutePath();
        this.ontology = ontology;
        this.diseaseMap = new HashMap<TermId, HpoDisease>();
        this.databasePrefixes = this.DEFAULT_DATABASE_PREFIXES;
    }

    public boolean validParse() {
        return this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public ImmutableMultimap<TermId, TermId> getTermToDiseaseMap() {
        return this.phenotypeToDiseaseMap;
    }

    public Map<TermId, HpoDisease> parse() throws PhenolException {
        HashMap disease2AnnotLineMap = new HashMap();
        ArrayListMultimap termToDisease = ArrayListMultimap.create();
        ImmutableList.Builder errorbuilder = new ImmutableList.Builder();
        try (BufferedReader br = new BufferedReader(new FileReader(this.annotationFilePath));){
            String line = br.readLine();
            while (line.startsWith("#")) {
                line = br.readLine();
            }
            if (!HpoAnnotationLine.isValidHeaderLine(line)) {
                throw new PhenolException(String.format("Annotation file at %s has invalid header (%s)", this.annotationFilePath, line));
            }
            while ((line = br.readLine()) != null) {
                HpoAnnotationLine aline = HpoAnnotationLine.constructFromString(line);
                if (!aline.hasValidNumberOfFields()) {
                    errorbuilder.add((Object)String.format("Invalid number of fields: %s", line));
                    continue;
                }
                if (!termToDisease.containsEntry((Object)aline.getPhenotypeId(), (Object)aline.getDiseaseTermId())) {
                    termToDisease.put((Object)aline.getPhenotypeId(), (Object)aline.getDiseaseTermId());
                }
                TermId diseaseId = aline.getDiseaseTermId();
                disease2AnnotLineMap.putIfAbsent(diseaseId, new ArrayList());
                List annots = (List)disease2AnnotLineMap.get(diseaseId);
                annots.add(aline);
            }
            ImmutableMultimap.Builder builderTermToDisease = new ImmutableMultimap.Builder();
            builderTermToDisease.putAll((Multimap)termToDisease);
            this.phenotypeToDiseaseMap = builderTermToDisease.build();
        }
        catch (IOException e) {
            throw new PhenolException(String.format("Could not read annotation file: %s", e.getMessage()));
        }
        for (TermId diseaseId : disease2AnnotLineMap.keySet()) {
            String diseaseDatabasePrefix = diseaseId.getPrefix();
            if (!this.databasePrefixes.contains(diseaseDatabasePrefix)) continue;
            List annots = (List)disease2AnnotLineMap.get(diseaseId);
            ImmutableList.Builder phenoListBuilder = ImmutableList.builder();
            ImmutableList.Builder inheritanceListBuilder = ImmutableList.builder();
            ImmutableList.Builder negativeTermListBuilder = ImmutableList.builder();
            String diseaseName = null;
            for (HpoAnnotationLine line : annots) {
                try {
                    if (this.isInheritanceTerm(line.getPhenotypeId())) {
                        inheritanceListBuilder.add((Object)line.getPhenotypeId());
                    } else if (line.isNOT()) {
                        negativeTermListBuilder.add((Object)line.getPhenotypeId());
                    } else {
                        HpoAnnotation tidm = HpoAnnotationLine.toHpoAnnotation(line, this.ontology);
                        phenoListBuilder.add((Object)tidm);
                    }
                    if (line.getDbObjectName() == null) continue;
                    diseaseName = line.getDbObjectName();
                }
                catch (Exception e) {
                    errorbuilder.add((Object)String.format("PHENOL ERROR] Line: %s--could not parse annotation: %s ", line.toString(), e.getMessage()));
                }
            }
            HpoDisease hpoDisease = new HpoDisease(diseaseName, diseaseId, (List)phenoListBuilder.build(), (List)inheritanceListBuilder.build(), (List)negativeTermListBuilder.build());
            this.diseaseMap.put(hpoDisease.getDiseaseDatabaseId(), hpoDisease);
        }
        this.errors = errorbuilder.build();
        return this.diseaseMap;
    }

    private boolean isInheritanceTerm(TermId tid) {
        return tid.equals((Object)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT) || OntologyAlgorithm.existsPath((Ontology)this.ontology, (TermId)tid, (TermId)HpoModeOfInheritanceTermIds.INHERITANCE_ROOT);
    }
}

