/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.obo.mpo;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.monarchinitiative.phenol.base.PhenolException;
import org.monarchinitiative.phenol.formats.mpo.MpGene;
import org.monarchinitiative.phenol.formats.mpo.MpGeneModel;
import org.monarchinitiative.phenol.formats.mpo.MpSimpleModel;
import org.monarchinitiative.phenol.io.OntologyLoader;
import org.monarchinitiative.phenol.io.obo.mpo.MpAnnotationParser;
import org.monarchinitiative.phenol.ontology.data.Ontology;
import org.monarchinitiative.phenol.ontology.data.TermId;

public class MpGeneParser {
    private final String mgiMarkerPath;
    private final String mgiGenePhenoPath;
    private final Ontology ontology;

    public MpGeneParser(String markerPath, String mgiGenePhenoPath, String ontologypath) throws PhenolException {
        this(markerPath, mgiGenePhenoPath, OntologyLoader.loadOntology(new File(ontologypath)));
    }

    public MpGeneParser(String markerPath, String mgiGenePhenoPath, Ontology mpo) {
        this.mgiMarkerPath = markerPath;
        this.mgiGenePhenoPath = mgiGenePhenoPath;
        this.ontology = mpo;
    }

    public Map<TermId, MpGene> parseMarkers() throws IOException, PhenolException {
        ImmutableMap.Builder bld = ImmutableMap.builder();
        BufferedReader br = new BufferedReader(new FileReader(this.mgiMarkerPath));
        String line = br.readLine();
        while ((line = br.readLine()) != null) {
            String[] fields = line.split("\t");
            TermId mgiId = TermId.of((String)fields[0]);
            bld.put((Object)mgiId, (Object)MpGene.createMpGene((TermId)mgiId, (String)fields[6], (String)fields[9]));
        }
        br.close();
        return bld.build();
    }

    public Map<TermId, MpGeneModel> parseMpGeneModels() {
        HashMap gene2simpleMap = new HashMap();
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        try {
            MpAnnotationParser annotParser = new MpAnnotationParser(this.mgiGenePhenoPath);
            Map<TermId, MpSimpleModel> simpleModelMap = annotParser.getGenotypeAccessionToMpModelMap();
            for (MpSimpleModel simplemod : simpleModelMap.values()) {
                TermId geneId = simplemod.getMarkerId();
                gene2simpleMap.putIfAbsent(geneId, new ArrayList());
                List lst = (List)gene2simpleMap.get(geneId);
                lst.add(simplemod);
            }
            for (TermId geneId : gene2simpleMap.keySet()) {
                List modCollection = (List)gene2simpleMap.get(geneId);
                MpGeneModel genemod = new MpGeneModel(geneId, this.ontology, true, modCollection);
                builder.put((Object)geneId, (Object)genemod);
            }
        }
        catch (PhenolException e) {
            e.printStackTrace();
        }
        return builder.build();
    }
}

