/*
 * Decompiled with CFR 0.152.
 */
package org.monarchinitiative.phenol.io.utils;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.Map;
import org.prefixcommons.CurieUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class CurieUtilBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurieUtilBuilder.class);
    private static final Map<String, String> DEFAULT_CURIE_MAP = ImmutableMap.copyOf(CurieUtilBuilder.generate());
    private static final CurieUtil DEFAULT_CURIE_UTIL = new CurieUtil(DEFAULT_CURIE_MAP);

    private CurieUtilBuilder() {
    }

    public static Map<String, String> defaultCurieMap() {
        return DEFAULT_CURIE_MAP;
    }

    public static CurieUtil defaultCurieUtil() {
        return DEFAULT_CURIE_UTIL;
    }

    public static CurieUtil withDefaultsAnd(Map<String, String> additionalCuries) {
        ImmutableMap.Builder merged = new ImmutableMap.Builder();
        merged.putAll(DEFAULT_CURIE_MAP);
        merged.putAll(additionalCuries);
        return new CurieUtil((Map)merged.build());
    }

    public static CurieUtil just(Map<String, String> curies) {
        return new CurieUtil((Map)ImmutableMap.copyOf(curies));
    }

    private static Map<String, String> generate() {
        try {
            InputStream inputStream = CurieUtilBuilder.class.getClassLoader().getResourceAsStream("curie_map.yaml");
            Yaml yaml = new Yaml();
            return (Map)yaml.load(inputStream);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return ImmutableMap.of();
        }
    }
}

