/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.geneontology.obographs.model.Edge;
import org.geneontology.obographs.model.Meta;
import org.geneontology.obographs.model.Node;
import org.geneontology.obographs.model.axiom.DomainRangeAxiom;
import org.geneontology.obographs.model.axiom.EquivalentNodesSet;
import org.geneontology.obographs.model.axiom.LogicalDefinitionAxiom;
import org.geneontology.obographs.model.axiom.PropertyChainAxiom;

public class Graph {
    private final List<Node> nodes;
    private final List<Edge> edges;
    private final String id;
    private final String lbl;
    private final Meta meta;
    private final List<EquivalentNodesSet> equivalentNodesSets;
    private final List<LogicalDefinitionAxiom> logicalDefinitionAxioms;
    private final List<DomainRangeAxiom> domainRangeAxioms;
    private final List<PropertyChainAxiom> propertyChainAxioms;

    private Graph(Builder builder) {
        this.id = builder.id;
        this.lbl = builder.lbl;
        this.meta = builder.meta;
        this.nodes = builder.nodes;
        this.edges = builder.edges;
        this.equivalentNodesSets = builder.equivalentNodesSets;
        this.logicalDefinitionAxioms = builder.logicalDefinitionAxioms;
        this.domainRangeAxioms = builder.domainRangeAxioms;
        this.propertyChainAxioms = builder.propertyChainAxioms;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public String getId() {
        return this.id;
    }

    public String getLbl() {
        return this.lbl;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public List<EquivalentNodesSet> getEquivalentNodesSets() {
        return this.equivalentNodesSets;
    }

    public List<LogicalDefinitionAxiom> getLogicalDefinitionAxioms() {
        return this.logicalDefinitionAxioms;
    }

    public List<DomainRangeAxiom> getDomainRangeAxioms() {
        return this.domainRangeAxioms;
    }

    public List<PropertyChainAxiom> getPropertyChainAxioms() {
        return this.propertyChainAxioms;
    }

    public static class Builder {
        @JsonProperty
        private String id;
        @JsonProperty
        private String lbl;
        @JsonProperty
        private Meta meta;
        @JsonProperty
        private List<Node> nodes;
        @JsonProperty
        private List<Edge> edges;
        @JsonProperty
        private List<EquivalentNodesSet> equivalentNodesSets;
        @JsonProperty
        private List<LogicalDefinitionAxiom> logicalDefinitionAxioms;
        @JsonProperty
        private List<DomainRangeAxiom> domainRangeAxioms;
        @JsonProperty
        private List<PropertyChainAxiom> propertyChainAxioms;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder lbl(String lbl) {
            this.lbl = lbl;
            return this;
        }

        public Builder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Builder nodes(List<Node> nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder edges(List<Edge> edges) {
            this.edges = edges;
            return this;
        }

        public Builder propertyChainAxioms(List<PropertyChainAxiom> propertyChainAxioms) {
            this.propertyChainAxioms = propertyChainAxioms;
            return this;
        }

        public Builder equivalentNodesSet(List<EquivalentNodesSet> equivalentNodesSets) {
            this.equivalentNodesSets = equivalentNodesSets;
            return this;
        }

        public Builder logicalDefinitionAxioms(List<LogicalDefinitionAxiom> logicalDefinitionAxioms) {
            this.logicalDefinitionAxioms = logicalDefinitionAxioms;
            return this;
        }

        public Builder domainRangeAxioms(List<DomainRangeAxiom> domainRangeAxioms) {
            this.domainRangeAxioms = domainRangeAxioms;
            return this;
        }

        public Graph build() {
            return new Graph(this);
        }
    }
}

