/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.geneontology.obographs.model.meta.BasicPropertyValue;
import org.geneontology.obographs.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.model.meta.XrefPropertyValue;

public class Meta {
    @JsonProperty
    private final DefinitionPropertyValue definition;
    @JsonProperty
    private final List<String> comments;
    @JsonProperty
    private final List<String> subsets;
    @JsonProperty
    private final List<XrefPropertyValue> xrefs;
    @JsonProperty
    private final List<SynonymPropertyValue> synonyms;
    @JsonProperty
    private final List<BasicPropertyValue> basicPropertyValues;
    @JsonProperty
    private final String version;
    @JsonProperty
    private final Boolean deprecated;

    private Meta(Builder builder) {
        this.definition = builder.definition;
        this.comments = builder.comments;
        this.subsets = builder.subsets;
        this.synonyms = builder.synonyms;
        this.xrefs = builder.xrefs;
        this.basicPropertyValues = builder.basicPropertyValues;
        this.version = builder.version;
        this.deprecated = builder.deprecated;
    }

    public DefinitionPropertyValue getDefinition() {
        return this.definition;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public List<XrefPropertyValue> getXrefs() {
        return this.xrefs;
    }

    @JsonIgnore
    public List<String> getXrefsValues() {
        return this.xrefs.stream().map(x -> x.getVal()).collect(Collectors.toList());
    }

    public List<String> getSubsets() {
        return this.subsets;
    }

    public List<SynonymPropertyValue> getSynonyms() {
        return this.synonyms;
    }

    public List<BasicPropertyValue> getBasicPropertyValues() {
        return this.basicPropertyValues;
    }

    public String getVersion() {
        return this.version;
    }

    public static class Builder {
        @JsonProperty
        public List<String> subsets;
        @JsonProperty
        public List<BasicPropertyValue> basicPropertyValues;
        @JsonProperty
        public List<SynonymPropertyValue> synonyms;
        @JsonProperty
        public List<String> comments;
        @JsonProperty
        public DefinitionPropertyValue definition;
        @JsonProperty
        public List<XrefPropertyValue> xrefs;
        @JsonProperty
        public String version;
        @JsonProperty
        public Boolean deprecated;

        public Builder definition(DefinitionPropertyValue definition) {
            this.definition = definition;
            return this;
        }

        public Builder definition(String defval) {
            this.definition = new DefinitionPropertyValue.Builder().val(defval).build();
            return this;
        }

        public Builder subsets(List<String> subsets) {
            this.subsets = subsets;
            return this;
        }

        public Builder subsets(String[] subsets) {
            this.subsets = Arrays.asList(subsets);
            return this;
        }

        public Builder addSubset(String subset) {
            if (this.subsets == null) {
                this.subsets(new ArrayList<String>());
            }
            this.subsets.add(subset);
            return this;
        }

        public Builder comments(List<String> comments) {
            this.comments = comments;
            return this;
        }

        public Builder basicPropertyValues(List<BasicPropertyValue> basicPropertyValues) {
            this.basicPropertyValues = basicPropertyValues;
            return this;
        }

        public Builder addBasicPropertyValue(BasicPropertyValue pv) {
            if (this.basicPropertyValues == null) {
                this.basicPropertyValues = new ArrayList<BasicPropertyValue>();
            }
            this.basicPropertyValues.add(pv);
            return this;
        }

        public Builder synonyms(List<SynonymPropertyValue> synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public Builder addSynonym(SynonymPropertyValue syn) {
            if (this.synonyms == null) {
                this.synonyms = new ArrayList<SynonymPropertyValue>();
            }
            this.synonyms.add(syn);
            return this;
        }

        public Builder addXref(XrefPropertyValue xref) {
            if (this.xrefs == null) {
                this.xrefs = new ArrayList<XrefPropertyValue>();
            }
            this.xrefs.add(xref);
            return this;
        }

        public Builder addComment(String comment) {
            if (this.comments == null) {
                this.comments = new ArrayList<String>();
            }
            this.comments.add(comment);
            return this;
        }

        public Builder xrefs(List<XrefPropertyValue> xrefs) {
            this.xrefs = xrefs;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Meta build() {
            return new Meta(this);
        }
    }
}

