/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.model.axiom;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geneontology.obographs.model.Edge;
import org.geneontology.obographs.model.Meta;
import org.geneontology.obographs.model.axiom.AbstractAxiom;

public class DomainRangeAxiom
extends AbstractAxiom {
    private final String predicateId;
    private final Set<String> domainClassIds;
    private final Set<String> rangeClassIds;
    private final Set<Edge> allValuesFromEdges;

    private DomainRangeAxiom(Builder builder) {
        super(builder);
        this.predicateId = builder.predicateId;
        this.domainClassIds = builder.domainClassIds;
        this.rangeClassIds = builder.rangeClassIds;
        this.allValuesFromEdges = builder.allValuesFromEdges;
    }

    public String getPredicateId() {
        return this.predicateId;
    }

    public Set<String> getDomainClassIds() {
        return this.domainClassIds;
    }

    public Set<String> getRangeClassIds() {
        return this.rangeClassIds;
    }

    public Set<Edge> getAllValuesFromEdges() {
        return this.allValuesFromEdges;
    }

    public static class Builder
    extends AbstractAxiom.Builder {
        @JsonProperty
        private String predicateId;
        @JsonProperty
        private Set<String> domainClassIds;
        @JsonProperty
        private Set<String> rangeClassIds;
        @JsonProperty
        private Meta meta;
        @JsonProperty
        private Set<Edge> allValuesFromEdges;

        public Builder predicateId(String predicateId) {
            this.predicateId = predicateId;
            return this;
        }

        public String predicateId() {
            return this.predicateId;
        }

        public Builder domainClassId(Set<String> domainClassId) {
            this.domainClassIds = this.domainClassIds;
            return this;
        }

        public Builder domainClassId(String domainClassId) {
            this.domainClassIds = Collections.singleton(domainClassId);
            return this;
        }

        public Builder addDomainClassId(String domainClassId) {
            if (this.domainClassIds == null) {
                this.domainClassIds = new HashSet<String>();
            }
            this.domainClassIds.add(domainClassId);
            return this;
        }

        public Builder rangeClassIds(Set<String> rangeClassIds) {
            this.rangeClassIds = rangeClassIds;
            return this;
        }

        public Builder rangeClassId(String rangeClassId) {
            this.rangeClassIds = Collections.singleton(rangeClassId);
            return this;
        }

        public Builder addRangeClassId(String rangeClassId) {
            if (this.rangeClassIds == null) {
                this.rangeClassIds = new HashSet<String>();
            }
            this.rangeClassIds.add(rangeClassId);
            return this;
        }

        public Builder addAllValuesFrom(Edge edge) {
            if (this.allValuesFromEdges == null) {
                this.allValuesFromEdges = new HashSet<Edge>();
            }
            this.allValuesFromEdges.add(edge);
            return this;
        }

        public DomainRangeAxiom build() {
            return new DomainRangeAxiom(this);
        }
    }
}

