/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.model.meta;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geneontology.obographs.model.Meta;
import org.geneontology.obographs.model.meta.AbstractPropertyValue;
import org.geneontology.obographs.model.meta.PropertyValue;

public class SynonymPropertyValue
extends AbstractPropertyValue
implements PropertyValue {
    private SynonymPropertyValue(Builder builder) {
        super(builder);
    }

    @JsonIgnore
    public boolean isExact() {
        return this.getPred().equals(PREDS.hasExactSynonym.toString());
    }

    @JsonIgnore
    public List<String> getTypes() {
        if (this.getMeta() != null) {
            return this.getMeta().getSubsets();
        }
        return new ArrayList<String>();
    }

    public static class Builder
    extends AbstractPropertyValue.Builder {
        @Override
        public Builder val(String val) {
            return (Builder)super.val(val);
        }

        @Override
        public Builder xrefs(List<String> xrefs) {
            return (Builder)super.xrefs(xrefs);
        }

        public Builder addType(String type) {
            super.meta(new Meta.Builder().subsets(Collections.singletonList(type)).build());
            return this;
        }

        public Builder scope(SCOPES scope) {
            PREDS pred = PREDS.hasRelatedSynonym;
            switch (scope) {
                case EXACT: {
                    pred = PREDS.hasExactSynonym;
                    break;
                }
                case RELATED: {
                    pred = PREDS.hasRelatedSynonym;
                    break;
                }
                case BROAD: {
                    pred = PREDS.hasBroadSynonym;
                    break;
                }
                case NARROW: {
                    pred = PREDS.hasNarrowSynonym;
                }
            }
            super.pred(pred.toString());
            return this;
        }

        public SynonymPropertyValue build() {
            return new SynonymPropertyValue(this);
        }
    }

    public static enum PREDS {
        hasExactSynonym,
        hasNarrowSynonym,
        hasBroadSynonym,
        hasRelatedSynonym;

    }

    public static enum SCOPES {
        EXACT,
        NARROW,
        BROAD,
        RELATED;

    }
}

