/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.owlapi;

import com.github.jsonldjava.core.Context;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.geneontology.obographs.io.PrefixHelper;
import org.geneontology.obographs.model.Edge;
import org.geneontology.obographs.model.Graph;
import org.geneontology.obographs.model.GraphDocument;
import org.geneontology.obographs.model.Meta;
import org.geneontology.obographs.model.Node;
import org.geneontology.obographs.model.axiom.DomainRangeAxiom;
import org.geneontology.obographs.model.axiom.EquivalentNodesSet;
import org.geneontology.obographs.model.axiom.ExistentialRestrictionExpression;
import org.geneontology.obographs.model.axiom.LogicalDefinitionAxiom;
import org.geneontology.obographs.model.axiom.PropertyChainAxiom;
import org.geneontology.obographs.model.meta.BasicPropertyValue;
import org.geneontology.obographs.model.meta.DefinitionPropertyValue;
import org.geneontology.obographs.model.meta.SynonymPropertyValue;
import org.geneontology.obographs.model.meta.XrefPropertyValue;
import org.geneontology.obographs.owlapi.SynonymVocabulary;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;

public class FromOwl {
    public static final String SUBCLASS_OF = "is_a";
    public static final String SUBPROPERTY_OF = "subPropertyOf";
    public static final String INVERSE_OF = "inverseOf";
    private PrefixHelper prefixHelper = new PrefixHelper();
    private Context context = this.prefixHelper.getContext();

    public GraphDocument generateGraphDocument(OWLOntology baseOntology) {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (OWLOntology ont : baseOntology.getImportsClosure()) {
            graphs.add(this.generateGraph(ont));
        }
        return new GraphDocument.Builder().graphs(graphs).build();
    }

    public Graph generateGraph(OWLOntology ontology) {
        Optional iri;
        Meta meta;
        SynonymVocabulary synonymVocabulary = new SynonymVocabulary();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<EquivalentNodesSet> ensets = new ArrayList<EquivalentNodesSet>();
        ArrayList<LogicalDefinitionAxiom> ldas = new ArrayList<LogicalDefinitionAxiom>();
        HashSet<String> nodeIds = new HashSet<String>();
        HashMap<String, Node.RDFTYPES> nodeTypeMap = new HashMap<String, Node.RDFTYPES>();
        HashMap<String, String> nodeLabelMap = new HashMap<String, String>();
        HashMap<String, DomainRangeAxiom.Builder> domainRangeBuilderMap = new HashMap<String, DomainRangeAxiom.Builder>();
        ArrayList<PropertyChainAxiom> pcas = new ArrayList<PropertyChainAxiom>();
        HashMap<String, Meta.Builder> nodeMetaBuilderMap = new HashMap<String, Meta.Builder>();
        HashSet<Object> untranslatedAxioms = new HashSet<Object>();
        for (OWLAxiom ax : ontology.getAxioms()) {
            Object p;
            String subj;
            Meta meta2 = this.getAnnotations(ax);
            if (ax instanceof OWLDeclarationAxiom) {
                OWLDeclarationAxiom dax = (OWLDeclarationAxiom)ax;
                OWLEntity e = dax.getEntity();
                if (e instanceof OWLClass) {
                    this.setNodeType(this.getClassId((OWLClass)e), Node.RDFTYPES.CLASS, nodeTypeMap);
                    continue;
                }
                if (e instanceof OWLProperty) {
                    this.setNodeType(this.getPropertyId((OWLProperty)e), Node.RDFTYPES.PROPERTY, nodeTypeMap);
                    continue;
                }
                if (!(e instanceof OWLNamedIndividual)) continue;
                this.setNodeType(this.getIndividualId((OWLIndividual)((OWLNamedIndividual)e)), Node.RDFTYPES.INDIVIDUAL, nodeTypeMap);
                continue;
            }
            if (ax instanceof OWLLogicalAxiom) {
                String obj;
                String subj2;
                if (ax instanceof OWLSubClassOfAxiom) {
                    OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)ax;
                    OWLClassExpression subc = sca.getSubClass();
                    OWLClassExpression supc = sca.getSuperClass();
                    subj = null;
                    if (!subc.isAnonymous()) {
                        subj = this.getClassId((OWLClass)subc);
                    }
                    if (subj != null) {
                        this.setNodeType(subj, Node.RDFTYPES.CLASS, nodeTypeMap);
                        if (supc.isAnonymous()) {
                            if (supc instanceof OWLObjectSomeValuesFrom) {
                                ExistentialRestrictionExpression r = this.getRestriction(supc);
                                if (r == null) {
                                    untranslatedAxioms.add(sca);
                                    continue;
                                }
                                Edge e = this.getEdge(subj, r.getPropertyId(), r.getFillerId());
                                edges.add(e);
                                continue;
                            }
                            if (!(supc instanceof OWLObjectAllValuesFrom)) continue;
                            OWLObjectAllValuesFrom avf = (OWLObjectAllValuesFrom)supc;
                            DomainRangeAxiom.Builder b2 = this.getDRBuilder(avf.getProperty(), domainRangeBuilderMap);
                            if (((OWLClassExpression)avf.getFiller()).isAnonymous()) continue;
                            Edge e = this.getEdge(subj, b2.predicateId(), this.getClassId(((OWLClassExpression)avf.getFiller()).asOWLClass()));
                            b2.addAllValuesFrom(e);
                            continue;
                        }
                        edges.add(this.getEdge(subj, SUBCLASS_OF, this.getClassId((OWLClass)supc)));
                        continue;
                    }
                    untranslatedAxioms.add(sca);
                    continue;
                }
                if (ax instanceof OWLClassAssertionAxiom) {
                    OWLClassAssertionAxiom ca = (OWLClassAssertionAxiom)ax;
                    subj2 = this.getIndividualId(ca.getIndividual());
                    String pred = "type";
                    OWLClassExpression cx = ca.getClassExpression();
                    if (cx.isAnonymous()) {
                        untranslatedAxioms.add(ca);
                        continue;
                    }
                    String obj2 = this.getClassId(cx.asOWLClass());
                    edges.add(this.getEdge(subj2, pred, obj2));
                    nodeIds.add(subj2);
                    nodeIds.add(obj2);
                    continue;
                }
                if (ax instanceof OWLObjectPropertyAssertionAxiom) {
                    OWLObjectPropertyAssertionAxiom opa = (OWLObjectPropertyAssertionAxiom)ax;
                    subj2 = this.getIndividualId(opa.getSubject());
                    obj = this.getIndividualId((OWLIndividual)opa.getObject());
                    if (((OWLObjectPropertyExpression)opa.getProperty()).isAnonymous()) {
                        untranslatedAxioms.add(opa);
                    } else {
                        String pred = this.getPropertyId(((OWLObjectPropertyExpression)opa.getProperty()).asOWLObjectProperty());
                        edges.add(this.getEdge(subj2, pred, obj));
                    }
                    nodeIds.add(subj2);
                    continue;
                }
                if (ax instanceof OWLEquivalentClassesAxiom) {
                    OWLClassExpression anonX;
                    OWLEquivalentClassesAxiom eca = (OWLEquivalentClassesAxiom)ax;
                    List xs = eca.getClassExpressionsAsList();
                    List anonXs = xs.stream().filter(x -> x.isAnonymous()).collect(Collectors.toList());
                    List namedXs = xs.stream().filter(x -> !x.isAnonymous()).collect(Collectors.toList());
                    Set<String> xClassIds = namedXs.stream().map(x -> this.getClassId((OWLClass)x)).collect(Collectors.toSet());
                    if (anonXs.size() == 0) {
                        EquivalentNodesSet enset = new EquivalentNodesSet.Builder().nodeIds(xClassIds).build();
                        ensets.add(enset);
                        continue;
                    }
                    if (anonXs.size() != 1 || namedXs.size() != 1 || !((anonX = (OWLClassExpression)anonXs.get(0)) instanceof OWLObjectIntersectionOf)) continue;
                    Set ixs = ((OWLObjectIntersectionOf)anonX).getOperands();
                    OBOClassDef classDef = this.getClassDef(ixs);
                    if (classDef != null) {
                        LogicalDefinitionAxiom lda = new LogicalDefinitionAxiom.Builder().definedClassId(this.getClassId((OWLClass)namedXs.get(0))).genusIds(classDef.genusClassIds).restrictions(classDef.restrs).build();
                        ldas.add(lda);
                        continue;
                    }
                    untranslatedAxioms.add(eca);
                    continue;
                }
                if (ax instanceof OWLObjectPropertyAxiom) {
                    if (ax instanceof OWLSubObjectPropertyOfAxiom) {
                        OWLSubObjectPropertyOfAxiom spa = (OWLSubObjectPropertyOfAxiom)ax;
                        if (((OWLObjectPropertyExpression)spa.getSubProperty()).isAnonymous() || ((OWLObjectPropertyExpression)spa.getSuperProperty()).isAnonymous()) continue;
                        subj2 = this.getPropertyId(((OWLObjectPropertyExpression)spa.getSubProperty()).asOWLObjectProperty());
                        obj = this.getPropertyId(((OWLObjectPropertyExpression)spa.getSuperProperty()).asOWLObjectProperty());
                        edges.add(this.getEdge(subj2, SUBPROPERTY_OF, obj));
                        continue;
                    }
                    if (ax instanceof OWLInverseObjectPropertiesAxiom) {
                        OWLInverseObjectPropertiesAxiom ipa = (OWLInverseObjectPropertiesAxiom)ax;
                        if (ipa.getFirstProperty().isAnonymous() || ipa.getSecondProperty().isAnonymous()) continue;
                        String p1 = this.getPropertyId(ipa.getFirstProperty().asOWLObjectProperty());
                        String p2 = this.getPropertyId(ipa.getSecondProperty().asOWLObjectProperty());
                        edges.add(this.getEdge(p1, INVERSE_OF, p2));
                        continue;
                    }
                    if (ax instanceof OWLSubPropertyChainOfAxiom) {
                        OWLSubPropertyChainOfAxiom spc = (OWLSubPropertyChainOfAxiom)ax;
                        if (spc.getSuperProperty().isAnonymous()) continue;
                        p = this.getPropertyId(spc.getSuperProperty().asOWLObjectProperty());
                        List<String> cpids = spc.getPropertyChain().stream().map(cp -> cp.isAnonymous() ? null : this.getPropertyId(cp.asOWLObjectProperty())).collect(Collectors.toList());
                        if (cpids.stream().filter(pid -> pid == null).collect(Collectors.toList()).size() != 0) continue;
                        pcas.add(new PropertyChainAxiom.Builder().predicateId((String)p).chainPredicateIds(cpids).build());
                        continue;
                    }
                    this.translateObjectPropertyAxiom(ax, domainRangeBuilderMap);
                    continue;
                }
                untranslatedAxioms.add(ax);
                continue;
            }
            if (!(ax instanceof OWLAnnotationAssertionAxiom)) continue;
            OWLAnnotationAssertionAxiom aaa = (OWLAnnotationAssertionAxiom)ax;
            p = aaa.getProperty();
            OWLAnnotationSubject s = aaa.getSubject();
            if (s instanceof IRI) {
                Meta.Builder nb;
                Meta.Builder nb2;
                subj = this.getNodeId((IRI)s);
                OWLAnnotationValue v = aaa.getValue();
                String lv = null;
                if (v instanceof OWLLiteral) {
                    lv = ((OWLLiteral)v).getLiteral();
                }
                IRI pIRI = p.getIRI();
                if (p.isLabel()) {
                    if (lv == null) continue;
                    nodeIds.add(subj);
                    nodeLabelMap.put(subj, lv);
                    continue;
                }
                if (this.isDefinitionProperty(pIRI)) {
                    if (lv == null) continue;
                    DefinitionPropertyValue def = ((DefinitionPropertyValue.Builder)new DefinitionPropertyValue.Builder().val(lv).xrefs((List)meta2.getXrefsValues())).build();
                    nb2 = this.getMetaBuilder(nodeMetaBuilderMap, subj);
                    nb2.definition(def);
                    nodeIds.add(subj);
                    continue;
                }
                if (this.isHasXrefProperty(pIRI)) {
                    if (lv == null) continue;
                    XrefPropertyValue xref = new XrefPropertyValue.Builder().val(lv).build();
                    nb2 = this.getMetaBuilder(nodeMetaBuilderMap, subj);
                    nb2.addXref(xref);
                    nodeIds.add(subj);
                    continue;
                }
                if (p.isDeprecated()) {
                    if (!aaa.isDeprecatedIRIAssertion()) continue;
                    nb = this.getMetaBuilder(nodeMetaBuilderMap, subj);
                    nb.deprecated(true);
                    continue;
                }
                if (p.isComment()) {
                    nb = this.getMetaBuilder(nodeMetaBuilderMap, subj);
                    nb.addComment(lv.toString());
                    continue;
                }
                if (this.isOboInOwlIdProperty(pIRI)) continue;
                if (this.isInSubsetProperty(pIRI)) {
                    nb = this.getMetaBuilder(nodeMetaBuilderMap, subj);
                    nb.addSubset(v.toString());
                    nodeIds.add(subj);
                    continue;
                }
                if (synonymVocabulary.contains(pIRI.toString())) {
                    SynonymPropertyValue.SCOPES scope = synonymVocabulary.get(pIRI.toString());
                    if (lv == null) continue;
                    SynonymPropertyValue syn = ((SynonymPropertyValue.Builder)new SynonymPropertyValue.Builder().scope(scope).val(lv).xrefs((List)meta2.getXrefsValues())).build();
                    Meta.Builder nb3 = this.getMetaBuilder(nodeMetaBuilderMap, subj);
                    nb3.addSynonym(syn);
                    nodeIds.add(subj);
                    continue;
                }
                nb = this.getMetaBuilder(nodeMetaBuilderMap, subj);
                String val = v instanceof IRI ? ((IRI)v).toString() : (v instanceof OWLLiteral ? ((OWLLiteral)v).getLiteral() : (v instanceof OWLAnonymousIndividual ? ((OWLAnonymousIndividual)v).getID().toString() : null));
                BasicPropertyValue pv = new BasicPropertyValue.Builder().pred(this.getPropertyId((OWLAnnotationProperty)p)).val(val).build();
                nb.addBasicPropertyValue(pv);
                nodeIds.add(subj);
                continue;
            }
            untranslatedAxioms.add(aaa);
        }
        for (String n : nodeIds) {
            Node.Builder nb = new Node.Builder().id(n).label((String)nodeLabelMap.get(n));
            if (nodeMetaBuilderMap.containsKey(n)) {
                meta = ((Meta.Builder)nodeMetaBuilderMap.get(n)).build();
                nb.meta(meta);
            }
            if (nodeTypeMap.containsKey(n)) {
                nb.type((Node.RDFTYPES)((Object)nodeTypeMap.get(n)));
            }
            nodes.add(nb.build());
        }
        String gid = null;
        String version = null;
        OWLOntologyID ontId = ontology.getOntologyID();
        if (ontId != null && (iri = ontId.getOntologyIRI()).isPresent()) {
            gid = this.getNodeId((IRI)iri.orNull());
            if (ontId.getVersionIRI().isPresent()) {
                version = this.getNodeId((IRI)ontId.getVersionIRI().orNull());
            }
        }
        meta = this.getAnnotations(ontology.getAnnotations(), version);
        List<DomainRangeAxiom> domainRangeAxioms = domainRangeBuilderMap.values().stream().map(b -> b.build()).collect(Collectors.toList());
        return new Graph.Builder().id(gid).meta(meta).nodes(nodes).edges(edges).equivalentNodesSet(ensets).logicalDefinitionAxioms(ldas).domainRangeAxioms(domainRangeAxioms).propertyChainAxioms(pcas).build();
    }

    private void translateObjectPropertyAxiom(OWLAxiom ax, Map<String, DomainRangeAxiom.Builder> domainRangeBuilderMap) {
        if (ax instanceof OWLObjectPropertyRangeAxiom) {
            OWLObjectPropertyRangeAxiom rax = (OWLObjectPropertyRangeAxiom)ax;
            OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)rax.getProperty();
            OWLClassExpression rc = (OWLClassExpression)rax.getRange();
            if (!rc.isAnonymous()) {
                DomainRangeAxiom.Builder b = this.getDRBuilder(p, domainRangeBuilderMap);
                b.addRangeClassId(this.getClassId(rc.asOWLClass()));
            }
        } else if (ax instanceof OWLObjectPropertyDomainAxiom) {
            OWLObjectPropertyDomainAxiom rax = (OWLObjectPropertyDomainAxiom)ax;
            OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)rax.getProperty();
            OWLClassExpression rc = rax.getDomain();
            if (!rc.isAnonymous()) {
                DomainRangeAxiom.Builder b = this.getDRBuilder(p, domainRangeBuilderMap);
                b.addDomainClassId(this.getClassId(rc.asOWLClass()));
            }
        }
    }

    private DomainRangeAxiom.Builder getDRBuilder(OWLObjectPropertyExpression p, Map<String, DomainRangeAxiom.Builder> domainRangeBuilderMap) {
        String pid;
        if (p.isAnonymous()) {
            // empty if block
        }
        if (!domainRangeBuilderMap.containsKey(pid = this.getPropertyId((OWLObjectProperty)p))) {
            domainRangeBuilderMap.put(pid, new DomainRangeAxiom.Builder().predicateId(pid));
        }
        return domainRangeBuilderMap.get(pid);
    }

    private void setNodeType(String id, Node.RDFTYPES t, Map<String, Node.RDFTYPES> nodeTypeMap) {
        nodeTypeMap.put(id, t);
    }

    private Meta.Builder getMetaBuilder(Map<String, Meta.Builder> nodeMetaBuilderMap, String id) {
        if (!nodeMetaBuilderMap.containsKey(id)) {
            nodeMetaBuilderMap.put(id, new Meta.Builder());
        }
        return nodeMetaBuilderMap.get(id);
    }

    private Meta getAnnotations(OWLAxiom ax) {
        return this.getAnnotations(ax.getAnnotations());
    }

    private Meta getAnnotations(Set<OWLAnnotation> anns) {
        return this.getAnnotations(anns, null);
    }

    private Meta getAnnotations(Set<OWLAnnotation> anns, String version) {
        ArrayList<XrefPropertyValue> xrefs = new ArrayList<XrefPropertyValue>();
        ArrayList<BasicPropertyValue> bpvs = new ArrayList<BasicPropertyValue>();
        ArrayList<String> inSubsets = new ArrayList<String>();
        boolean isDeprecated = false;
        for (OWLAnnotation ann : anns) {
            String val;
            OWLAnnotationProperty p = ann.getProperty();
            OWLAnnotationValue v = ann.getValue();
            String string = val = v instanceof IRI ? ((IRI)v).toString() : ((OWLLiteral)v).getLiteral();
            if (ann.isDeprecatedIRIAnnotation()) {
                isDeprecated = true;
                continue;
            }
            if (this.isHasXrefProperty(p.getIRI())) {
                xrefs.add(new XrefPropertyValue.Builder().val(val).build());
                continue;
            }
            if (this.isInSubsetProperty(p.getIRI())) {
                inSubsets.add(new String(val));
                continue;
            }
            if (this.isHasSynonymTypeProperty(p.getIRI())) {
                inSubsets.add(new String(val));
                continue;
            }
            bpvs.add(new BasicPropertyValue.Builder().pred(this.getPropertyId(p)).val(val).build());
        }
        Meta.Builder b = new Meta.Builder();
        if (version != null) {
            b.version(version);
        }
        Meta.Builder builder = b.basicPropertyValues(bpvs).subsets(inSubsets).xrefs(xrefs);
        if (isDeprecated) {
            builder.deprecated(true);
        }
        return builder.build();
    }

    private Edge getEdge(String subj, String pred, String obj) {
        return this.getEdge(subj, pred, obj, null);
    }

    private Edge getEdge(String subj, String pred, String obj, List<ExistentialRestrictionExpression> gciQualifiers) {
        return new Edge.Builder().sub(subj).pred(pred).obj(obj).build();
    }

    private ExistentialRestrictionExpression getRestriction(OWLClassExpression x) {
        if (x instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom r = (OWLObjectSomeValuesFrom)x;
            OWLObjectPropertyExpression p = r.getProperty();
            OWLClassExpression f = (OWLClassExpression)r.getFiller();
            if (p instanceof OWLObjectProperty && !f.isAnonymous()) {
                return new ExistentialRestrictionExpression.Builder().propertyId(this.getPropertyId((OWLObjectProperty)p)).fillerId(this.getClassId((OWLClass)f)).build();
            }
        }
        return null;
    }

    private OBOClassDef getClassDef(Set<OWLClassExpression> ixs) {
        OBOClassDef def = new OBOClassDef();
        boolean isLDA = true;
        for (OWLClassExpression ix : ixs) {
            if (!ix.isAnonymous()) {
                def.genusClassIds.add(this.getClassId((OWLClass)ix));
                continue;
            }
            if (ix instanceof OWLObjectSomeValuesFrom) {
                def.restrs.add(this.getRestriction(ix));
                continue;
            }
            isLDA = false;
            break;
        }
        if (!isLDA) {
            return null;
        }
        return def;
    }

    private String getPropertyId(OWLObjectProperty p) {
        return p.getIRI().toString();
    }

    private String getPropertyId(OWLAnnotationProperty p) {
        return p.getIRI().toString();
    }

    private String getClassId(OWLClass c) {
        return c.getIRI().toString();
    }

    private String getPropertyId(OWLProperty p) {
        return p.getIRI().toString();
    }

    private String getIndividualId(OWLIndividual owlIndividual) {
        if (owlIndividual instanceof OWLNamedIndividual) {
            return owlIndividual.asOWLNamedIndividual().getIRI().toString();
        }
        return owlIndividual.asOWLAnonymousIndividual().getID().toString();
    }

    private String getNodeId(IRI s) {
        return s.toString();
    }

    public boolean isDefinitionProperty(IRI iri) {
        return iri.toString().equals("http://purl.obolibrary.org/obo/IAO_0000115");
    }

    public boolean isHasXrefProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#hasDbXref");
    }

    public boolean isInSubsetProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#inSubset");
    }

    public boolean isHasSynonymTypeProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#hasSynonymType");
    }

    public boolean isOboInOwlIdProperty(IRI iri) {
        return iri.toString().equals("http://www.geneontology.org/formats/oboInOwl#id");
    }

    class OBOClassDef {
        List<String> genusClassIds = new ArrayList<String>();
        List<ExistentialRestrictionExpression> restrs = new ArrayList<ExistentialRestrictionExpression>();

        OBOClassDef() {
        }
    }
}

