/*
 * Decompiled with CFR 0.152.
 */
package org.geneontology.obographs.runner;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geneontology.obographs.io.OgJsonGenerator;
import org.geneontology.obographs.io.OgYamlGenerator;
import org.geneontology.obographs.model.GraphDocument;
import org.geneontology.obographs.owlapi.FromOwl;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class RunEngine {
    @Parameter(names={"-v", "--verbose"}, description="Level of verbosity")
    private Integer verbose = 1;
    @Parameter(names={"-o", "--out"}, description="output json/yaml file")
    private String outpath;
    @Parameter(names={"-t", "--to"}, description="output format: json or yaml")
    private String outformat;
    @Parameter(description="Files")
    private List<String> files = new ArrayList<String>();
    OWLOntologyManager manager;

    public static void main(String ... args) throws OWLOntologyCreationException, IOException, OWLOntologyStorageException {
        RunEngine main = new RunEngine();
        new JCommander((Object)main, args);
        main.run();
    }

    public void run() throws OWLOntologyCreationException, IOException, OWLOntologyStorageException {
        String doc;
        FromOwl fromOwl = new FromOwl();
        File file = new File(this.files.get(0));
        OWLOntology ont = this.loadOWL(file);
        GraphDocument gd = fromOwl.generateGraphDocument(ont);
        if (this.outformat == null || this.outformat.equals("json")) {
            doc = OgJsonGenerator.render(gd);
        } else if (this.outformat.equals("yaml")) {
            doc = OgYamlGenerator.render(gd);
        } else {
            throw new IOException("no such format " + this.outformat);
        }
        if (this.outpath == null) {
            System.out.println(doc);
        } else {
            FileUtils.writeStringToFile((File)new File(this.outpath), (String)doc);
        }
    }

    private OWLOntologyManager getOWLOntologyManager() {
        if (this.manager == null) {
            this.manager = OWLManager.createOWLOntologyManager();
        }
        return this.manager;
    }

    public OWLOntology loadOWL(IRI iri) throws OWLOntologyCreationException {
        return this.getOWLOntologyManager().loadOntology(iri);
    }

    public OWLOntology loadOWL(File file) throws OWLOntologyCreationException {
        IRI iri = IRI.create((File)file);
        return this.getOWLOntologyManager().loadOntologyFromOntologyDocument(iri);
    }
}

