/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.FloatCollection;
import com.carrotsearch.hppcrt.FloatLookupContainer;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import java.util.Arrays;

public abstract class AbstractFloatCollection
implements FloatCollection {
    protected FloatLookupContainer testContainer;
    protected FloatPredicate testPredicate;
    protected FloatPredicate containsTestPredicate = new FloatPredicate(){

        public final boolean apply(float k) {
            return AbstractFloatCollection.this.testContainer.contains(k);
        }
    };
    protected FloatPredicate containsNegateTestPredicate = new FloatPredicate(){

        public final boolean apply(float k) {
            return !AbstractFloatCollection.this.testContainer.contains(k);
        }
    };
    protected FloatPredicate negatePredicate = new FloatPredicate(){

        public final boolean apply(float k) {
            return !AbstractFloatCollection.this.testPredicate.apply(k);
        }
    };

    public int removeAll(FloatLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    public int retainAll(FloatLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    public int retainAll(FloatPredicate predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    public float[] toArray(float[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (FloatCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    public float[] toArray() {
        try {
            return this.toArray(new float[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

